/*!
 * \file       dia_IOCtrlAudioSinkSet.cpp
 *
 * \brief      IOCtrl used to chang the audio sink
 *
 * \details    IOCtrl used to chang the audio sink
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2011-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

#ifndef __INCLUDED_DIA_IOCTRL_AUDIO_SINK_SET__
#include <common/services/uds/production/dia_IOCtrlAudioSinkSet.h>
#endif

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_IOCTRL_BY_IDENTIFIER__
#include <common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h>
#endif

#define DIA_C_U8_IOCTRL_AUDIO_SINK_SET_PAYLOAD_SIZE   ((tU8) 1)

namespace dia {

//------------------------------------------------------------------------------

IOCtrlAudioSinkSet::IOCtrlAudioSinkSet ( void )
   : dia_IOCtrlSignalRestrictedToRemoteControl("dia::IOCtrlAudioSinkSet",DIA_C_U16_DID_RBCM_AUDIO_SINK_ACTIVE)
{}

//------------------------------------------------------------------------------

IOCtrlAudioSinkSet::~IOCtrlAudioSinkSet ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IAudioSinkListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia::IOCtrlAudioSinkSet::~IOCtrlAudioSinkSet !!!");
       DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
IOCtrlAudioSinkSet::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia::IOCtrlAudioSinkSet::handleRequest()");

   if ( ctrlValue->size() != DIA_C_U8_IOCTRL_AUDIO_SINK_SET_PAYLOAD_SIZE ) return DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT;

   tDiaResult retCode = DIA_E_NO_ERROR;

   tU8 sinkID = ctrlValue->at(0);

   /* possible range: 0x00 */
   /* invalid range:  0x01 ... 0xFF */
   if ( sinkID == 0x00 )
   {
      dia_IAudioSink* pInterface = 0;
      if ( (querySysAdapterInterface<dia_IAudioSink>(&pInterface) == DIA_SUCCESS) && pInterface )
      {
         (void) setSysAdapterListener<dia_IAudioSinkListener>(this);

         retCode = pInterface->setAudioSink(DIA_EN_AUDIO_SINK_SPEAKER,DIA_EN_AUDIO_SOUNDSYSTEM_SPEAKER);
         if ( retCode != DIA_SUCCESS )
         {
            DIA_TR_ERR("dia::IOCtrlAudioSinkSet::handleRequest: NO INTERFACE POINTER !!");
            retCode = DIA_E_CONDITIONS_NOT_CORRECT;
         }
      }
      else
      {
         DIA_TR_ERR("dia::IOCtrlAudioSinkSet::handleRequest: NO INTERFACE POINTER !!");
         retCode = DIA_E_CONDITIONS_NOT_CORRECT;
      }
   }
   else
   {
      DIA_TR_ERR("dia::IOCtrlAudioSinkSet::handleRequest: invalid audio sink detected (0x%02x) !", sinkID);
      retCode = DIA_E_OUT_OF_RANGE;
   }

   if ( retCode != DIA_E_NO_ERROR )
   {
      (void) unsetSysAdapterListener<dia_IAudioSinkListener>(this);
      DIA_TR_ERR("dia::IOCtrlAudioSinkSet --- SEND TO AUDIO SERVER FAILED!!!!");
   }
   else
   {
      // now initialize the counter for the timer
      vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);
      mIsResultReady = FALSE;
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
IOCtrlAudioSinkSet::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia::IOCtrlAudioSinkSet::vOnTerminate()");

   (void) unsetSysAdapterListener<dia_IAudioSinkListener>(this);

   // this ioctrl is no longer active
   eSetStatus(status);
   mIsResultReady = TRUE;

   return DIA_SUCCESS;
}


//-----------------------------------------------------------------------------

void
IOCtrlAudioSinkSet::onAudioSinkSet ( tDiaResult result )
{
   dia_tclFnctTrace trc("dia::IOCtrlAudioSinkSet::onAudioSinkSet");

   (void) unsetSysAdapterListener<dia_IAudioSinkListener>(this);
   mIsResultReady = TRUE;

   if ( result == DIA_SUCCESS )
   {
      DIA_TR_INF("dia::IOCtrlAudioSinkSet::onAudioSinkSet SUCCESSFUL !!!");
   }
   else
   {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia::IOCtrlAudioSinkSet::onAudioSinkSet DIA_FAILED !!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

void
IOCtrlAudioSinkSet::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia::IOCtrlAudioSinkSet::handleTimeout");
   (void) unsetSysAdapterListener<dia_IAudioSinkListener>(this);
}

}


