/*
 * dia_IOCtrlAudioFader.cpp
 *
 *  Created on: 24.10.2012
 *      Author: shw2abt
 *--------------------------------------------------------------------------------
 * Date				|	User ID		|	Modification
 * 27/5/2016		|	bma9kor		|	Audio fader functions facilitate Diaglib communication  (CMG3G-10183)
 *--------------------------------------------------------------------------------
 */
// TTFis: DIA_REQ UDS 06 2F 64 14 03 09

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/production/dia_IOCtrlAudioFader.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//#define DATA_START 3
//#define DATA_LENGTH 2

//------------------------------------------------------------------------------

dia_IOCtrlAudioFader::dia_IOCtrlAudioFader(tVoid) :
   dia_IOCtrlSignalRestrictedToRemoteControl (
         DIA_C_U16_DID_RBCM_AUDIO_FADER,
         DIA_EN_IOCTRL_SIGTYPE_AUDIO_FADER,
         1 /* Payload Length */
   )
{
}

//------------------------------------------------------------------------------

dia_IOCtrlAudioFader::~dia_IOCtrlAudioFader(tVoid)
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_IAudioBalFaderListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlAudioFader::~dia_IOCtrlAudioFader !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
_BP_CATCH_END}

 //------------------------------------------------------------------------------

//lint -e715 shw2abt: timerValue is not used in this context
tDiaResult
dia_IOCtrlAudioFader::handleRequest(tU8 /*timerValue*/, std::vector<tU8>* ctrlValue)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioFader::handleRequest(tU8,vector<tU8>*)");
   tBool errorDetected = TRUE;

   DIA_TR_INF("dia_IOCtrlAudioFader::handleRequest: start Handling.");
   dia_IAudioBalFader* pInterface = 0;
   if (querySysAdapterInterface<dia_IAudioBalFader>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         (tVoid) setSysAdapterListener<dia_IAudioBalFaderListener>(this);
         tS8 fader = (tS8) ctrlValue->at(0);
         if ( fader > -10 && fader < 10 ) {
            if (pInterface->dia_setAudioFader(fader) == DIA_SUCCESS) {
               errorDetected = FALSE;
            }
         } else {
            DIA_TR_ERR("dia_IOCtrlAudioFader::handleRequest FADER has invalid value!");
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_IAudioBalFaderListener>(this);
      DIA_TR_ERR("dia_IOCtrlAudioFader ---  SEND TO AUDIO SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}
//lint +e715

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlAudioFader::vOnTerminate(dia_eIOCtrlStatus status)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlAudioFader::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if (eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE) {
      if (status == DIA_EN_IOCTRL_STATUS_INACTIVE) {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_IAudioBalFader* pInterface = 0;
      if (querySysAdapterInterface<dia_IAudioBalFader>(&pInterface) == DIA_SUCCESS) {
         if (pInterface) {
            (tVoid) setSysAdapterListener<dia_IAudioBalFaderListener>(this);
            if (pInterface->dia_setAudioFader(0x00) != DIA_SUCCESS) {
               DIA_TR_ERR("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SELECT AUDIO Fader !!!");
            }
         }
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlAudioFader::vOnAudioFader ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioFader::vOnAudioFader");
   
   (tVoid) unsetSysAdapterListener<dia_IAudioBalFaderListener>(this);
   mIsResultReady = TRUE;
   if( success == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_IOCtrlAudioFader::vOnAudioFader SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlAudioFader::vOnAudioFader DIA_FAILED !!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlAudioFader::handleTimeout(tVoid)
{
   dia_tclFnctTrace trc("dia_IOCtrlAudioFader::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_IAudioBalFaderListener>(this);
}


