/*
 * dia_IOCtrlAudioBalance.h
 *
 *  Created on: 24.10.2012
 *      Author: shw2abt
 */
/*
 * The system implements audioBalance to provide the diagnostic tester the ability to control the audio balance.
 * This IOControl will only be accepted if the IOControl remoteControl is currently active.
 *--------------------------------------------------------------------------------
 * Date				|	User ID		|	Modification
 * 27/5/2016		|	bma9kor		|	Audio balance functions facilitate Diaglib communication  (CMG3G-10183)
 *--------------------------------------------------------------------------------
 */
// TTFis: DIA_REQ UDS 06 2F 64 13 03 06

#ifndef DIA_IOCTRLAUDIOBALANCE_H_
#define DIA_IOCTRLAUDIOBALANCE_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL_RESTRICTED_TO_REMOTE_CONTROL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignalRestrictedToRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIOBALFADER_LISTENER__
#include "common/interfaces/dia_IAudioBalFaderListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlAudioBalance
   : public dia_IOCtrlSignalRestrictedToRemoteControl,
     public dia_IAudioBalFaderListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlAudioBalance ( tVoid );
   //! class destructor
   virtual ~dia_IOCtrlAudioBalance ( tVoid );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //!
   virtual tVoid handleTimeout ( tVoid );

   //! Signal to inform requester about success of the tuner change request
   virtual tVoid vOnAudioBalance ( tDiaResult success );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

};


#endif /* DIA_IOCTRLAUDIOBALANCE_H_ */
