/*
 * \file        dia_EcuResetKeyOnOffReset.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Apr 30, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_ECURESET_MANAGER__
#include "common/framework/protocols/uds/ecureset/dia_EcuResetManager.h"
#endif

#include "common/services/uds/production/dia_EcuResetKeyOnOffReset.h"

//------------------------------------------------------------------------------

dia_EcuResetKeyOnOffReset::dia_EcuResetKeyOnOffReset ( tCString name, dia_ResetType resetType )
   : dia_EcuResetPlugin ( name, resetType )
{
   dia_tclFnctTrace oTrace("dia_EcuResetKeyOnOffReset::dia_EcuResetKeyOnOffReset()");
}

//------------------------------------------------------------------------------

dia_EcuResetKeyOnOffReset::~dia_EcuResetKeyOnOffReset ( void )
{
}

//------------------------------------------------------------------------------

tDiaResetResponse
dia_EcuResetKeyOnOffReset::handleRequest ( void )
{
   dia_tclFnctTrace oTrace("dia_EcuResetKeyOnOffReset::handleRequest()");

   dia_ISpm* pInterface = OSAL_NULL;
   tBool errorDetected = TRUE;
   tDiaResult diaResult = querySysAdapterInterface<dia_ISpm>(&pInterface);

   if (DIA_SUCCESS==diaResult)
   {
      if (pInterface)
      {
         DIA_TR_INF("dia_EcuResetKeyOnOffReset::handleRequest got interface");
         (void) setSysAdapterListener<dia_ISpmListener>(this);

         if (pInterface->signalSystemShutdown(DIA_EN_SPM_SHUTDOWN_MODE_OFF_LASTSTATE) == DIA_SUCCESS)
         {
            DIA_TR_INF("dia_EcuResetKeyOnOffReset::handleRequest SUCCESSFUL");
            errorDetected = FALSE;
         }
         else
         {
            (void) unsetSysAdapterListener<dia_ISpmListener>(this);
            DIA_TR_ERR("dia_EcuResetKeyOnOffReset --- signalSystemRestart SEND TO SPM SERVER FAILED");
         }
      }
   }

   return errorDetected ? DIA_RESET_NEG_RESPONSE : DIA_RESET_FORCE_POS_RESPONSE;
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

void
dia_EcuResetKeyOnOffReset::vOnSystemFastShutdown(tDiaResult result)
{
   dia_tclFnctTrace oTrace("dia_EcuResetKeyOnOffReset::vOnSystemFastShutdown()");

   DIA_TR_INF("dia_EcuResetKeyOnOffReset::vOnSystemFastShutdown returned %s", (DIA_SUCCESS==result) ? "DIA_SUCCESS" : " different than DIA_SUCCESS" );

   getInstanceOfEcuResetManager()->vOnEcuResetUpdate(this, result);

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
}
