/*
 * \file        dia_EcuResetHardReset.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Apr 22, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_ECURESET_MANAGER__
#include "common/framework/protocols/uds/ecureset/dia_EcuResetManager.h"
#endif

#include "common/services/uds/production/dia_EcuResetHardReset.h"

//------------------------------------------------------------------------------

dia_EcuResetHardReset::dia_EcuResetHardReset ( tCString name, dia_ResetType resetType )
   : dia_EcuResetPlugin ( name, resetType )
{
   dia_tclFnctTrace oTrace("dia_EcuResetHardReset::dia_EcuResetHardReset()");
}

//------------------------------------------------------------------------------

dia_EcuResetHardReset::~dia_EcuResetHardReset ( void )
{
}

//------------------------------------------------------------------------------

tDiaResetResponse
dia_EcuResetHardReset::handleRequest ( void )
{
   dia_tclFnctTrace oTrace("dia_EcuResetHardReset::handleRequest()");

   dia_ISpm* pInterface = OSAL_NULL;
   tBool errorDetected = TRUE;
   tDiaResult diaResult = querySysAdapterInterface<dia_ISpm>(&pInterface);

   if (DIA_SUCCESS==diaResult)
   {
      if (pInterface)
      {
         DIA_TR_INF("dia_EcuResetHardReset::handleRequest got interface");
         (void) setSysAdapterListener<dia_ISpmListener>(this);

         if (pInterface->signalSystemReset(DIA_EN_SPM_CORE_RESTART_MODE_ECU_FAST) == DIA_SUCCESS)
         {
            DIA_TR_INF("dia_EcuResetHardReset::handleRequest SUCCESSFUL");
            errorDetected = FALSE;
         }
         else
         {
            (void) unsetSysAdapterListener<dia_ISpmListener>(this);
            DIA_TR_ERR("dia_EcuResetHardReset --- signalSystemRestart SEND TO SPM SERVER FAILED");
         }
      }
      else
      {
         DIA_TR_ERR("dia_EcuResetHardReset::handleRequest --- Interface is null unexpectedly.");
      }
   }
   else
   {
      DIA_TR_ERR("dia_EcuResetHardReset::handleRequest --- Interface for dia_ISpm not got.");
   }

   return errorDetected ? DIA_RESET_NEG_RESPONSE : DIA_RESET_WAIT_FOR_SPM;
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

void
dia_EcuResetHardReset::vOnSystemRestart ( tDiaResult result )
{
   dia_tclFnctTrace oTrace("dia_EcuResetHardReset::vOnSystemRestart()");

   DIA_TR_INF("dia_EcuResetHardReset::vOnSystemRestart returned %s", (DIA_SUCCESS==result) ? "DIA_SUCCESS" : "different than DIA_SUCCESS" );

   getInstanceOfEcuResetManager()->vOnEcuResetUpdate(this, result);

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
}
