/*
 * \file        dia_EcuResetFastShutdown.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Apr 28, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_ECURESET_MANAGER__
#include "common/framework/protocols/uds/ecureset/dia_EcuResetManager.h"
#endif

#include "common/services/uds/production/dia_EcuResetFastShutdown.h"

//------------------------------------------------------------------------------

dia_EcuResetFastShutdown::dia_EcuResetFastShutdown ( tCString name, dia_ResetType resetType )
   : dia_EcuResetPlugin ( name, resetType )
{
   dia_tclFnctTrace oTrace("dia_EcuResetFastShutdown::dia_EcuResetFastShutdown()");
}

//------------------------------------------------------------------------------

dia_EcuResetFastShutdown::~dia_EcuResetFastShutdown ( void )
{
}

//------------------------------------------------------------------------------

tDiaResetResponse
dia_EcuResetFastShutdown::handleRequest ( void )
{
   dia_tclFnctTrace oTrace("dia_EcuResetFastShutdown::handleRequest()");

   dia_ISpm* pInterface = OSAL_NULL;
   tBool errorDetected = TRUE;
   tDiaResult diaResult = querySysAdapterInterface<dia_ISpm>(&pInterface);

   if (DIA_SUCCESS==diaResult)
   {
      if (pInterface)
      {
         DIA_TR_INF("dia_EcuResetFastShutdown::handleRequest got interface");
         (void) setSysAdapterListener<dia_ISpmListener>(this);

         if (pInterface->signalSystemShutdown(DIA_EN_SPM_SHUTDOWN_MODE_FAST) == DIA_SUCCESS)
         {
            DIA_TR_INF("dia_EcuResetFastShutdown::handleRequest SUCCESSFUL");
            errorDetected = FALSE;
         }
         else
         {
            (void) unsetSysAdapterListener<dia_ISpmListener>(this);
            DIA_TR_ERR("dia_EcuResetFastShutdown --- signalSystemRestart SEND TO SPM SERVER FAILED");
         }
      }
   }

   return errorDetected ? DIA_RESET_NEG_RESPONSE : DIA_RESET_WAIT_FOR_SPM;
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

void
dia_EcuResetFastShutdown::vOnSystemFastShutdown(tDiaResult result)
{
   dia_tclFnctTrace oTrace("dia_EcuResetFastShutdown::vOnSystemFastShutdown()");

   DIA_TR_INF("dia_EcuResetFastShutdown::vOnSystemFastShutdown returned %s", (DIA_SUCCESS==result) ? "DIA_SUCCESS" : " different than DIA_SUCCESS" );

   getInstanceOfEcuResetManager()->vOnEcuResetUpdate(this, result);

   (void) unsetSysAdapterListener<dia_ISpmListener>(this);
}
