#include <string.h>
#include <stdlib.h>
#include <unistd.h>

typedef enum
{
    ERR_CLEARENV   =10,
    ERR_PATHMALLOC =11,
    ERR_CONFSTR    =12,
    ERR_SETENV     =13,
} EXIT_CODE;

void ensureNumericOnly(char* argument) {
    for (int i = 0; argument[i] != '\0'; ++i) {
        if (argument[i] < '0' || argument[i] > '9') {   // Outside of numeric range AND
            argument[i] = '0';                          // Replace it with '0'
        }
    }
}

void ensureAlphaNumOnly(char* argument) {
    for (int i = 0; argument[i] != '\0'; ++i) {
        if ( ( argument[i] < '0' || argument[i] > '9' ) &&      // Outside of numeric range AND
             ( argument[i] < 'A' || argument[i] > 'Z' ) &&      // Outside of capital letters AND
             ( argument[i] < 'a' || argument[i] > 'z' ) &&      // Outside of small letters AND
             ( argument[i] != '_'                     )    )    // Not an undersocre
        {
            argument[i] = '0';                                  // Replace it with '0'
        }
    }
}


int main(int argc, char** argv) {
    setuid(0);

    // Sanitize environment variables
    char *pathbuf;
    size_t n;

    if (clearenv() != 0) {
      return ERR_CLEARENV;
    }

    n = confstr(_CS_PATH, NULL, 0);
    if (n == 0) {
      return ERR_CONFSTR;
    }

    if ((pathbuf = (char*)malloc(n)) == NULL) {
      return ERR_PATHMALLOC;
    }

    if (confstr(_CS_PATH, pathbuf, n) == 0) {
      return ERR_CONFSTR;
    }

    if (setenv("PATH", pathbuf, 1) == -1) {
      return ERR_SETENV;
    }

    // Sanitize input arguments
    for (int i = 1; i < argc; ++i){
        if (strncmp(argv[i], "-m", 3) == 0) { // Allowed Modules: filesystem, fingerprint, raw, v850
            if (++i < argc) {
                ensureAlphaNumOnly(argv[i]);
            }
        }
        else if (strncmp(argv[i], "-a", 3) == 0) { // Allowed Areas: root, static, boot, magics, emmc_boot, 
            if (++i < argc) {                      // nor, emmc_user, application, bootload, bootmanager
                ensureAlphaNumOnly(argv[i]);
            }
        }
        else if (strncmp(argv[i], "-p", 3) == 0) { // Allowed Partitions: root, static, boot, magics, emmc_boot, 
            if (++i < argc) {                      // nor, emmc_user, application, bootload, bootmanager
                ensureAlphaNumOnly(argv[i]);
            }
        }       
        else if (strncmp(argv[i], "-c", 3) == 0) { // COOKIE is an integer so only digits are allowed
            if (++i < argc) {
                ensureNumericOnly(argv[i]);
            }
        }
        else {
            argv[i][0] = '\0';
        }
    }
    return execv("/opt/bosch/checksum/check_cksum.sh", argv);
}
