/*!
 * \file       dia_ToUdsHelpers.h
 *
 * \brief      Functions to convert base-types to uds-format
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_TO_UDS_HELPERS__
#define __INCLUDED_DIA_TO_UDS_HELPERS__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrl.h"

#define DIA_CHECK_UDS_LEN_EQ(LEN)               \
   if (LEN != uds.size()) {                     \
      return false;                             \
   }


namespace dia {

#define DIA_VEC_TO_UDS(DIATYPE, DIAVAR, UDSVAR, NUMELEM)  {             \
   size_t numElemInList=DIAVAR.size();                                 \
   std::vector<DIATYPE>::const_iterator iter=DIAVAR.begin();            \
   for (uint32_t i=0; i<NUMELEM;++i) {                                  \
      if (i<numElemInList) {                                            \
         dia_diaToUds(*iter, UDSVAR);                                   \
         ++iter;                                                        \
      } else {                                                          \
         DIATYPE diaElem;                                               \
         dia_diaToUds(diaElem, UDSVAR);                                 \
      }                                                                 \
   }                                                                    \
}


uint8_t dia_mapRoutineStatusType1ToUds(dia_eRoutineStatus diaStatus);



bool dia_u8ToUds(uint8_t val, std::vector<tU8>& uds);

bool dia_u16ToUds(uint16_t val, std::vector<tU8>& uds);

bool dia_u32ToUds(uint32_t val, std::vector<tU8>& uds);

bool dia_stringToUds(char const *str, size_t minBytes, size_t maxBytes, std::vector<tU8>& uds);
bool dia_stringToUds(std::string const & str, size_t minBytes, size_t maxBytes, std::vector<tU8>& uds);
bool dia_stringToUds(std::string const & str, std::vector<tU8>& uds);


}
#endif
