/*!
 * \file       dia_ToUdsHelpers.cpp
 *
 * \brief      Functions to convert base-types to uds-format
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 */

#include "common/services/uds/generic/dia_ToUdsHelpers.h"

namespace dia {

uint8_t dia_mapRoutineStatusType1ToUds(dia_eRoutineStatus diaStatus)
{
   switch(diaStatus) {
      case DIA_EN_RTCTRL_STATUS_UNKNOWN: return 0xFF;
      case DIA_EN_RTCTRL_STATUS_IDLE: return 0xFF;
      case DIA_EN_RTCTRL_STATUS_IN_PROGRESS: return 0xFF;
      case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK: return 0x00;
      case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK: return 0x01;
      case DIA_EN_RTCTRL_STATUS_ABORTED: return 0xFF;
      case DIA_EN_RTCTRL_STATUS_TIMED_OUT: return 0xFF;
      default: return 0xFF;
   };
}

bool dia_u8ToUds(uint8_t val, std::vector<tU8>& uds) {
   uds.push_back(val);
   return true;
}

bool dia_u16ToUds(uint16_t val, std::vector<tU8>& uds) {
   uds.push_back((uint8_t)(val >> 8));
   uds.push_back((uint8_t)(val >> 0));
   return true;
}

bool dia_u32ToUds(uint32_t val, std::vector<tU8>& uds) {
   uds.push_back((uint8_t)(val >> 24));
   uds.push_back((uint8_t)(val >> 16));
   uds.push_back((uint8_t)(val >> 8));
   uds.push_back((uint8_t)(val >> 0));
   return true;
}

bool dia_stringToUds(char const *str, size_t minBytes, size_t maxBytes, std::vector<tU8>& uds) {
   uint32_t numBytes=(uint32_t)strlen(str);
   printf("dia_stringToUds:numBytes=%u minBytes=%u maxBytes=%u\n", numBytes, (uint32_t)minBytes, (uint32_t)maxBytes);
   if (numBytes > maxBytes) {
      numBytes=(uint32_t)maxBytes;
   }

   printf("dia_stringToUds:numBytes=%u\n", numBytes);
   for (uint32_t i=0; i<numBytes;++i) {
   printf("dia_stringToUds:push=%02x\n", (uint8_t)str[i]);
      uds.push_back((uint8_t)str[i]);
   }
   for (uint32_t i=numBytes;i<minBytes;++i) {
      uds.push_back((uint8_t)0);
   }
   return true;
}

bool dia_stringToUds(std::string const & str, size_t minBytes, size_t maxBytes, std::vector<tU8>& uds) {
   return dia_stringToUds(str.c_str(), minBytes, maxBytes, uds);
}
bool dia_stringToUds(std::string const & str, std::vector<tU8>& uds) {
   return dia_stringToUds(str.c_str(), str.size(), str.size(), uds);
}


}
