/*
 * dia_SrvHandlerGenericWIFINameRead.cpp
 *
 *  Created on: 13.07.2015
 *      Author: nbs3kor
 */

#include "dia_SrvHandlerGenericWIFINameRead.h"

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#define DIA_U16_READDATA_BY_ID_REQUEST_LENGTH  ((tU16) (1 + mDIDLen))

using namespace dia;
//-----------------------------------------------------------------------------

dia_SrvHandlerGenericWIFINameRead::dia_SrvHandlerGenericWIFINameRead ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name,sid,did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericWIFINameRead::dia_SrvHandlerGenericWIFINameRead(tU16)");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericWIFINameRead::~dia_SrvHandlerGenericWIFINameRead ( void )
{}

//-----------------------------------------------------------------------------

void
dia_SrvHandlerGenericWIFINameRead::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericWIFINameRead::vOnProcessRequest");

   // data length contains at least sid, ctrl byte and DID --> 4 bytes minimum
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();
   if ( dataLength !=  (DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + 1) ) // one additional byte contains the message length
   {
      DIA_TR_INF("INVALID DATA LENGTH. EXPECTED %d BYTES BUT RECEIVED %d BYTES !!", (DIA_U16_READDATA_BY_ID_REQUEST_LENGTH+1),dataLength);
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT));
      return;
   }

   if ( vecArgs.size() )
   {
      tU32 propID = VoidCast<tU32>(vecArgs[0]);
      std::vector<tU8> u8data_wifiname1;

	  // retrieve size of property
	  auto length_wifiname1 = dia_getPropertySize(propID); //DIA_PROP_LENGTH_MAX;
      u8data_wifiname1.reserve(length_wifiname1);
      u8data_wifiname1.resize(length_wifiname1);

	  tDiaResult retCode = dia_getProperty(propID, u8data_wifiname1);

	  //u8data_wifiname1.resize(length_wifiname1);

	  if ( retCode == DIA_SUCCESS )
	  {
	     DIA_TR_INF("dia_SrvHandlerGenericWIFINameRead::vOnProcessRequest wifiname 1 Read successful");
	  }
	  else
	  {
		 DIA_TR_INF("UNABLE TO READ ITEM WIFINAME1 (READ OPERATION FAILED) !!");
		 vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
		 return;
	  }

	  // data memory
	  propID = VoidCast<tU32>(vecArgs[1]);
      std::vector<tU8> u8data_wifiname2;

	  // retrieve size of property
	  auto length_wifiname2 = dia_getPropertySize(propID); //DIA_PROP_LENGTH_MAX;
      u8data_wifiname2.reserve(length_wifiname2);
      u8data_wifiname2.resize(length_wifiname2);
	  retCode = dia_getProperty(propID, u8data_wifiname2);

	  if ( retCode == DIA_SUCCESS )
	  {
		  DIA_TR_INF("dia_SrvHandlerGenericWIFINameRead::vOnProcessRequest wifiname 2 Read successful");
	  }
	  else
	  {
		 DIA_TR_INF("UNABLE TO READ ITEM WIFINAME2 (READ OPERATION FAILED) !!");
		 vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
		 return;
	  }

	  tU16 wifiname_iterator = 0;

	  // Sending back the positive answer
	  oDiagMsgBuffer().vSetPosResp();
	  oDiagMsgBuffer().vSetDataLength(static_cast<tU16>(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + u8data_wifiname1.size() + u8data_wifiname2.size()));

	  for ( tU16 wifiname1_iterator = 0; wifiname_iterator < u8data_wifiname1.size(); ++wifiname_iterator, ++wifiname1_iterator)
      {
	    (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + wifiname_iterator), u8data_wifiname1[wifiname1_iterator]);
	  }

	  for ( tU16 wifiname2_iterator = 0; wifiname_iterator < (u8data_wifiname1.size() + u8data_wifiname2.size()); ++wifiname_iterator, ++wifiname2_iterator)
	  {
		 (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DIA_U16_READDATA_BY_ID_REQUEST_LENGTH + wifiname_iterator), u8data_wifiname2[wifiname2_iterator]);
	  }

	  vResReadyAndQuit();
   }
   else
   {
      DIA_TR_INF("UNABLE TO READ ITEM (PROPERTY NOT PASSED AS PARAMETER");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
   }
}


