/*
 * dia_SrvHandlerGenericTransferData.cpp
 *
 *  Created on: 28.01.2014
 *      Author: gib2hi
 */

/*
 * dia_SrvHandlerGenericRequestDownload.cpp
 *
 *  Created on: 13.01.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_GENERIC_SERVICE_HANDLER_TRANSFER_DATA__
#include "common/services/uds/generic/dia_SrvHandlerGenericTransferData.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_METHODS_PROJECT__
#include "project/framework/factory/dia_factoryMethodsProject.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_MANAGER__
#include "common/framework/datadownload/dia_DataDownloadManager.h"
#endif

#define MSG_DATA_OFFSET 1

//#define DIA_C_U8_REQDNL_BYTEPOS_SRV_ID          ((tU8) 0)
#define DIA_C_U8_TRANSDATA_BYTEPOS_BSN            ((tU8) 1)

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericTransferData::dia_SrvHandlerGenericTransferData ( void )
   : dia_ServiceHandlerUDS("dia_SrvHandlerGenericTransferData",DIA_C_U8_UDS_SID_TRANSFER_DATA )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericTransferData::dia_SrvHandlerGenericTransferData()");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericTransferData::~dia_SrvHandlerGenericTransferData ( void )
{}

//----------------------------------------------------------------------

void
dia_SrvHandlerGenericTransferData::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericTransferData::vProcessRequest");

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();

   std::vector<tU8> requestData;
   for ( tU16 len = 0; len < (oDiagMsgBuffer().u16GetDataLength()-MSG_DATA_OFFSET); len++ )
   {
      requestData.push_back(pU8[len+MSG_DATA_OFFSET]);
   }
//   tDiaResult retCode = validateData(requestData);
//
//   if ( retCode != DIA_SUCCESS )
//   {
//      // Sending back the Negative answer
//      DIA_TR_INF("dia_SrvHandlerGenericTransferData: FAILED (DATA VALIDATION) !!");
//      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(retCode));
//      return;
//   }

   dia_DataDownloadManager* pDnlManager = getInstanceOfDataDownloadManager();
   if ( !pDnlManager )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandlerGenericTransferData: FAILED (NO ACCESS TO DOWNLOAD MANAGER) !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
      return;
   }

   std::vector<tU8> responseData;
   tDiaResult retCode = pDnlManager->transferData(requestData,responseData);

   if ( retCode != DIA_SUCCESS )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandlerGenericTransferData: FAILED (DATA TRANSFER) !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(retCode));
      return;
   }

   // Sending back the positive answer
   DIA_TR_INF("dia_SrvHandlerGenericTransferData: SUCCEEDED");
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength((tU16) (2 + responseData.size()));
   (void) oDiagMsgBuffer().vSetDataU8((tU16) 1, requestData[1]);
   for ( tU16 i=0; i<responseData.size(); i++ )
   {
      (void)oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(i + 2), responseData[i]);
   }

   vResReadyAndQuit();
}

////----------------------------------------------------------------------
//
//tDiaResult
//dia_SrvHandlerGenericTransferData::validateData ( std::vector<tU8>& data )
//{
//   // check if request contains no data
//   if ( data.size() <= 2 ) return DIA_E_OUT_OF_RANGE;
//
//   // check range of block sequence number
//   tU8 bsn = data[DIA_C_U8_TRANSDATA_BYTEPOS_BSN];
//   if ( bsn == 0 ) return DIA_E_WRONG_BLOCK_SEQUENCE_NUMBER;
//
//   dia_DataDownloadManager* pDnlManager = getInstanceOfDataDownloadManager();
//   if ( !pDnlManager ) return DIA_E_CONDITIONS_NOT_CORRECT;
//
//   // check if a up- or download was requested before
//   const dia_Dataset* pDataset = pDnlManager->getRequestedDataset();
//   if ( !pDataset ) return DIA_E_SEQUENCE_ERROR;
//
//   // check if transmitted data does not match the requested length
//   //if ( (data.size() - 2) != pDataset->getSize() ) return DIA_E_TRANSFER_DATA_SUSPENDED;
//
//   return DIA_SUCCESS; //checkLength((tU32) data.size(),length,length);
//}
//
////-----------------------------------------------------------------------------
//
//tDiaResult
//dia_SrvHandlerGenericTransferData::checkLength ( tU32 length, tU32 minValue, tU32 maxValue )
//{
//   return ((length >= minValue) && (length <= maxValue)) ? DIA_SUCCESS : DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT;
//}
//


