/*
 * dia_SrvHandlerGenericTemperatureRead.h
 *
 *  Created on: 09.07.2012
 *      Author: shw2abt, lei wang
 */

#ifndef DIA_SRVHANDLER_GENERICTEMPERATUREREAD_H_
#define DIA_SRVHANDLER_GENERICTEMPERATUREREAD_H_

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_HEATCONTROL_LISTENER__
#include "common/interfaces/dia_IHeatControlListener.h"
#endif


class dia_SrvHandlerGenericTemperatureRead
   : public dia_ServiceHandlerUDS,
     public dia_IHeatControlListenerImpl
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerGenericTemperatureRead);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericTemperatureRead);

public:
   //! class constructor
   dia_SrvHandlerGenericTemperatureRead ( tCString name, tU8 sid, tU16 did , tU8 temperatureID );
   dia_SrvHandlerGenericTemperatureRead ( tCString name, tU8 sid, tU16 did );

   //! class destructor
   virtual ~dia_SrvHandlerGenericTemperatureRead(void);

   /**
    * \brief       handle the received request
    *
    *            Function recieves the message via the oDiagMsgBuffer and send it to the SA.
    *            The SystemAdapter analysis the data and send it via CCA to the responsible component.
    *
    * \param[in]   void*     -
    * \param[in]   void*     -
    */
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );

   //! list of available temperatures
   /**
    * \brief       received temperature list
    *
    *            Function recieves the message via its parameter and extract the wanted temperature information.
    *            After verification of the SA answer it sends the value to the tester.
    *
    * \param[in]   std::list<dia_tHeatCtrlTemperature>& tempList       list of all available temperatures
    */
   virtual void vOnTemperatureInfo ( std::list<dia_tHeatCtrlTemperature>& tempList );

   //! list of available sensor state
   /**
    * \brief       received sensor state list
    *
    *            Function recieves the message via its parameter and extract the wanted sensor states.
    *            After verification of the SA answer it sends the value to the tester.
    *
    * \param[in]   std::list<dia_tHeatCtrlSensorState>& stateList       list of sensor states
    */
//   virtual void vOnSensorStateInfo ( std::list<dia_tHeatCtrlSensorState>& stateList );

   //! react on function level
   /**
    * \brief       function level
    *
    *            Function recieves the message via its parameter and extract the wanted emergency function.
    *            After verification of the SA answer it sends the value to the tester.
    *
    * \param[in]   std::list<dia_tHeatCtrlEmergencyFunc>& funcList       list of all available emergency function
    */
   virtual void vOnEmergencyFunc ( std::list<dia_tHeatCtrlEmergencyFunc>& funcList );

   //! convertion function
   dia_eHeatCtrlFuncLevel getFuncLevelPerEmergencyFunc ( dia_eHeatCtrlEmergencyFuncID emergencyFuncID ) const;

protected:

   dia_eHeatCtrlTemperatureClass getTemperatureClass ( void ) const;
   void vResponseOnCustomerReq ( std::list<dia_tHeatCtrlTemperature>& tempList ) const;
   void vResponseOnProductionReq ( std::list<dia_tHeatCtrlTemperature>& tempList );
   dia_eHeatCtrlTemperatureQuality getDiaQuality (tU8 u8Quality) const;

   tU8 mTemperatureID;
   tBool mProductionRequest;
};

#endif /* DIA_SRVHANDLER_GENERICTEMPERATUREREAD_H_ */
