/*
 * dia_SrvHandlerGenericTemperatureRead.cpp
 *
 *  Created on: 09.07.2012
 *      Author: shw2abt
 */


#include "common/services/uds/generic/dia_SrvHandlerGenericTemperatureRead.h"

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TEMPERATURE_HISTOGRAM__
#include "common/interfaces/dia_ITemperatureHistogram.h"
#endif

#ifndef __DIA_SRVHANDLER_GENERIC_TEMPERATURE_HISTOGRAM_READ__
#include "common/services/uds/generic/dia_SrvHandlerGenericTemperatureHistogramRead.h"
#endif


namespace dia {

//-----------------------------------------------------------------------------
dia_SrvHandlerGenericTemperatureHistogramRead::dia_SrvHandlerGenericTemperatureHistogramRead ( tCString name, tU8 sid, tU16 did, dia_eHeatCtrlTemperatureID temperatureID )
   : dia_ServiceHandlerUDS(name,sid,(tU16) did),
     mTemperatureID(temperatureID)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericTemperatureHistogramRead::dia_SrvHandlerGenericTemperatureHistogramRead(void)");
}

//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
dia_SrvHandlerGenericTemperatureHistogramRead::~dia_SrvHandlerGenericTemperatureHistogramRead( void )
{
   (void) unsetSysAdapterListener<ITemperatureHistogramListener>(this);
}

//-------------------------------------------------------------------------------
void
dia_SrvHandlerGenericTemperatureHistogramRead::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericTemperatureHistogramRead::vProcessRequest");

   tU8 nrc = DIA_SUCCESS;

   uint32_t dataLen=oDiagMsgBuffer().u16GetDataLength() ;
   if (oDiagMsgBuffer().getFormat() == dia_MessageBuffer::format_length_and_data) {
      dataLen=(uint32_t)(dataLen-1);
   }
   do {
      if( dataLen != 3 )
      {
         DIA_TR_ERR("dia_SrvHandlerGenericTemperatureHistogramRead::vProcessRequest: invalid len:%u", dataLen);
         nrc=DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT;
         break;
      }
      ITemperatureHistogram *pInterface=nullptr;
      if ( querySysAdapterInterface<ITemperatureHistogram>(&pInterface) != DIA_SUCCESS ) {
         DIA_TR_ERR("dia_SrvHandlerGenericTemperatureHistogramRead::vProcessRequest: query interface failed");
         nrc=DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT;
         break;
      }
      if (!pInterface) {
         DIA_TR_ERR("dia_SrvHandlerGenericTemperatureHistogramRead::vProcessRequest: pInterface is 0");
         nrc=DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT;
         break;
      }
      ITemperatureHistogramListener *pListener=(ITemperatureHistogramListener*) this;
      DIA_TR_ERR("dia_SrvHandlerGenericTemperatureHistogramRead::vProcessRequest: pListener=%p", pListener);
      (void) setSysAdapterListener<ITemperatureHistogramListener>(this);

      if (pInterface->getTemperatureHistogram(mTemperatureID) != DIA_SUCCESS) {
         DIA_TR_ERR("dia_SrvHandlerGenericTemperatureHistogramRead::vProcessRequest: getTemperatureHistogram() failed");
         (void) unsetSysAdapterListener<ITemperatureHistogramListener>(this);
         nrc=DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT;
         break;
      }
   } while (0);

   if ( nrc!=DIA_SUCCESS ) {
      DIA_TR_ERR(" ---  SEND request to  ITemperatureHistogram failed !!!!");
      oDiagMsgBuffer().vSetNegResp(nrc);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------
void
dia_SrvHandlerGenericTemperatureHistogramRead::onTemperatureHistogram (dia_tTemperatureHistogram const &histogram)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericTemperatureHistogramRead::onTemperatureHistogram");

   (void) unsetSysAdapterListener<ITemperatureHistogramListener>(this);

   uint8_t nrc=DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT;
   DIA_TR_INF("dia_SrvHandlerGenericTemperatureHistogramRead::onTemperatureHistogram(): id=%u", histogram.mId);
   if (histogram.mId != mTemperatureID) {
      DIA_TR_INF("dia_SrvHandlerGenericTemperatureHistogramRead::onTemperatureHistogram: wrong id");
   }

   else if ( !histogram.mData )
   {
      DIA_TR_INF("dia_SrvHandlerGenericTemperatureHistogramRead::onTemperatureHistogram: no data");
   }
   else {
      nrc=DIA_SUCCESS;
   }

   if (nrc != DIA_SUCCESS) {
      oDiagMsgBuffer().vSetNegResp(nrc);
      vResReadyAndQuit();
      return;
   }

   // assemble response, set len and enforce format_raw
   oDiagMsgBuffer().vSetDataLength(3 + DIA_TEMPERATURE_HISTOGRAM_LENGTH * 4);

   std::array<uint32_t, DIA_TEMPERATURE_HISTOGRAM_LENGTH> const &input=*(histogram.mData);

   tU8 u8DataPos=0;
   //    (void) oDiagMsgBuffer().vSetDataU8(u8DataPos, sid);
   oDiagMsgBuffer().vSetPosResp();
   u8DataPos=(uint8_t)(u8DataPos+1);
   //(void) oDiagMsgBuffer().setDataU32BigEndian(u8DataPos, did);
   u8DataPos=(uint8_t)(u8DataPos+2);

   for (std::array<uint32_t, DIA_TEMPERATURE_HISTOGRAM_LENGTH>::const_iterator iter = input.begin();
        iter != input.end();
        ++iter )
   {
      DIA_TR_INF("dia_SrvHandlerGenericTemperatureHistogramRead::onTemperatureHistogram(): add temp %u", *iter);
      (void) oDiagMsgBuffer().setDataU32BigEndian(u8DataPos, (*iter) * 60);
      u8DataPos=(uint8_t)(u8DataPos+4);
   }

   vResReadyAndQuit();
}



}
