/*
 * dia_SrvHandlerGenericSessionControl.h
 *
 *  Created on: 07.05.2012
 *      Author: gib2hi
 */

#ifndef DIA_SRVHANDLER_GENERIC_SESSIONCONTROL_H_
#define DIA_SRVHANDLER_GENERIC_SESSIONCONTROL_H_

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include <common/framework/protocols/uds/dia_ServiceHandlerUDS.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__
#include <common/interfaces/dia_ISessionListener.h>
#endif


class dia_SrvHandlerGenericSessionControl
    : public dia_ServiceHandlerUDS,
      public dia_ISessionListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_SrvHandlerGenericSessionControl);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericSessionControl);

public:
   //! class constructor that provides initial session
   dia_SrvHandlerGenericSessionControl ( tU8 initialSession );

   //! process the received request
   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );

   //! lookup keys for this service handler
   virtual tDiaResult makeLookupKeys ( std::vector<dia_LookupKey*>& keys );

   //! notification about session change
   virtual void vOnSessionChanged ( tU8 newSession, tU8 oldSession );

   //! implementation for timeout notifications (initiates negative response 0x22)
   virtual void vOnTimeout ( void );

protected:
   //! requested session
   tU8 mSessionID;
};

#endif /* DIA_SRVHANDLER_GENERIC_SESSIONCONTROL_H_ */
