/*
 * dia_SrvHandlerGenericRequestUpload.cpp
 *
 *  Created on: 10.03.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_GENERIC_SERVICE_HANDLER_REQUEST_UPLOAD__
#include "common/services/uds/generic/dia_SrvHandlerGenericRequestUpload.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_METHODS_PROJECT__
#include "project/framework/factory/dia_factoryMethodsProject.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_MANAGER__
#include "common/framework/datadownload/dia_DataDownloadManager.h"
#endif

#define MSG_DATA_OFFSET 1

#define DIA_C_U8_REQDNL_BYTEPOS_SRV_ID          ((tU8) 0)
#define DIA_C_U8_REQDNL_BYTEPOS_FMT_ID          ((tU8) 1)
#define DIA_C_U8_REQDNL_BYTEPOS_ADDRFMT_ID      ((tU8) 2)
#define DIA_C_U8_REQDNL_BYTEPOS_STARTADDR       ((tU8) 3)

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericRequestUpload::dia_SrvHandlerGenericRequestUpload ( /*tU8 addrSizeInBytes, tU8 uncomprMemSizeInBytes*/ )
   : dia_ServiceHandlerUDS("dia_SrvHandlerGenericRequestUpload",DIA_C_U8_UDS_SID_REQUEST_UPLOAD ) //,
//     mCompressionMode(DIA_EN_DATA_COMPRESSION_NONE),
//     mEncryptionMode(DIA_EN_DATA_ENCRYPTION_NONE),
//     mLengthOfMemoryAddress(addrSizeInBytes),
//     mLengthOfUncrompressedMemorySize(uncomprMemSizeInBytes)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericRequestUpload::dia_SrvHandlerGenericRequestUpload()");
//   dia_tclFnctTrace trc("dia_SrvHandlerGenericRequestUpload::dia_SrvHandlerGenericRequestUpload(tU8,tU8)");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericRequestUpload::~dia_SrvHandlerGenericRequestUpload ( void )
{}

//----------------------------------------------------------------------

void
dia_SrvHandlerGenericRequestUpload::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericRequestUpload::vOnProcessRequest");

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();

   std::vector<tU8> requestData;
   for ( tU16 len = 0; len < (oDiagMsgBuffer().u16GetDataLength()-MSG_DATA_OFFSET); len++ )
   {
      requestData.push_back(pU8[len+MSG_DATA_OFFSET]);
   }

//   tDiaResult retCode = validateData(requestData);
//
//   if ( retCode != DIA_SUCCESS )
//   {
//      // Sending back the Negative answer
//      DIA_TR_INF("dia_SrvHandlerGenericRequestUpload: FAILED (DATA VALIDATION) !!");
//      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(retCode));
//      return;
//   }

   dia_DataDownloadManager* pDnlManager = getInstanceOfDataDownloadManager();
   if ( !pDnlManager )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandlerGenericRequestUpload: FAILED (NO ACCESS TO DOWNLOAD MANAGER) !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
      return;
   }

//   tU32 startAddress = 0;
//   tU32 shiftValue   = (mLengthOfMemoryAddress - 1) * 8;
//   for ( tU16 i=0; i<mLengthOfMemoryAddress; i++ )
//   {
//      startAddress |= ((tU32) requestData[DIA_C_U8_REQDNL_BYTEPOS_STARTADDR+i]) << shiftValue;
//      shiftValue   -= 8;
//   }
//
//   tU32 memSize = 0;
//   shiftValue   = (mLengthOfUncrompressedMemorySize - 1) * 8;
//   for ( tU16 i=0; i<mLengthOfUncrompressedMemorySize; i++ )
//   {
//      memSize |= ((tU32) requestData[DIA_C_U8_REQDNL_BYTEPOS_STARTADDR + mLengthOfMemoryAddress+i]) << shiftValue;
//      shiftValue   -= 8;
//   }
//
//   DIA_TR_INF("StartAddress: 0x%08x",startAddress);
//   DIA_TR_INF("DataLength  : 0x%08x",memSize);

//   retCode = pDnlManager->requestUpload(startAddress,memSize);
   tDiaResult retCode = pDnlManager->requestUpload(requestData);
   if ( retCode != DIA_SUCCESS )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandlerGenericRequestUpload: FAILED (DATA UPLOAD REQUEST) !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(retCode));
      return;
   }

   // Sending back the positive answer
   DIA_TR_INF("dia_SrvHandlerGenericRequestUpload: SUCCEEDED");
   const std::vector<tU8>* pResponseData = pDnlManager->getResponseData();
   if ( !pResponseData )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandlerGenericRequestUpload: NO RESPONSE DATA AVAILABLE !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
      return;
   }

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength((tU16) (pResponseData->size() + 1));
   for ( tU16 j=0; j<((tU16) pResponseData->size()); j++ )
   {
      (void) oDiagMsgBuffer().vSetDataU8(tU16(j+1), pResponseData->at(j));
   }

   vResReadyAndQuit();
}

////----------------------------------------------------------------------
//
//tDiaResult
//dia_SrvHandlerGenericRequestUpload::validateData ( std::vector<tU8>& data )
//{
//   tU8 compressionMethod = (data[DIA_C_U8_REQDNL_BYTEPOS_FMT_ID] & 0xF0) >> 4;
//   tU8 encryptionMethod  =  data[DIA_C_U8_REQDNL_BYTEPOS_FMT_ID] & 0x0F;
//
//   if ( mCompressionMode != compressionMethod ) return DIA_E_OUT_OF_RANGE;
//   if ( mEncryptionMode  != encryptionMethod  ) return DIA_E_OUT_OF_RANGE;
//
//   tU8 lengthOfUncrompressedMemorySize = (data[DIA_C_U8_REQDNL_BYTEPOS_ADDRFMT_ID] & 0xF0) >> 4;
//   tU8 lengthOfMemoryAddress           =  data[DIA_C_U8_REQDNL_BYTEPOS_ADDRFMT_ID] & 0x0F;
//
//   if ( mLengthOfUncrompressedMemorySize != lengthOfUncrompressedMemorySize ) return DIA_E_OUT_OF_RANGE;
//   if ( mLengthOfMemoryAddress  != lengthOfMemoryAddress  ) return DIA_E_OUT_OF_RANGE;
//
//   tU16 length = 3 /* sid + format identifiers */ + lengthOfMemoryAddress + lengthOfUncrompressedMemorySize;
//
//   return checkLength((tU32) data.size(),length,length);
//}
//
////-----------------------------------------------------------------------------
//
//tDiaResult
//dia_SrvHandlerGenericRequestUpload::checkLength ( tU32 length, tU32 minValue, tU32 maxValue )
//{
//   return ((length >= minValue) && (length <= maxValue)) ? DIA_SUCCESS : DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT;
//}
//
//
//
