/*
 * dia_SrvHandlerGenericRequestTransferExit.cpp
 *
 *  Created on: 28.01.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_GENERIC_SERVICE_HANDLER_REQUEST_TRANSFER_EXIT__
#include "common/services/uds/generic/dia_SrvHandlerGenericRequestTransferExit.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_METHODS_PROJECT__
#include "project/framework/factory/dia_factoryMethodsProject.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_MANAGER__
#include "common/framework/datadownload/dia_DataDownloadManager.h"
#endif

#define MSG_DATA_OFFSET 1

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericRequestTransferExit::dia_SrvHandlerGenericRequestTransferExit ( void )
   : dia_ServiceHandlerUDS("dia_SrvHandlerGenericRequestTransferExit",DIA_C_U8_UDS_SID_REQUEST_TRANSFER_EXIT )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericRequestTransferExit::dia_SrvHandlerGenericRequestTransferExit()");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericRequestTransferExit::~dia_SrvHandlerGenericRequestTransferExit ( void )
{}

//----------------------------------------------------------------------

void
dia_SrvHandlerGenericRequestTransferExit::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericRequestTransferExit::vOnProcessRequest");

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();

   std::vector<tU8> requestData;
   for ( tU16 len = 0; len < (oDiagMsgBuffer().u16GetDataLength()-MSG_DATA_OFFSET); len++ )
   {
      requestData.push_back(pU8[len+MSG_DATA_OFFSET]);
   }

   dia_DataDownloadManager* pDnlManager = getInstanceOfDataDownloadManager();
   if ( !pDnlManager )
   {
      // Sending back the Negative answer
      DIA_TR_ERR("dia_SrvHandlerGenericRequestTransferExit: FAILED (NO ACCESS TO DOWNLOAD MANAGER) !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
      return;
   }

   if (setSysAdapterListener<dia_IDataDownloadListener>(this) != DIA_SUCCESS)
   {
      DIA_TR_ERR("dia_SrvHandlerGenericRequestTransferExit: FAILED (NO REG AS LISTENER) !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
      return;
   }

   tDiaResult retCode = pDnlManager->transferExit(requestData);
   if ( retCode != DIA_SUCCESS )
   {
      // Sending back the Negative answer
      DIA_TR_ERR("dia_SrvHandlerGenericRequestTransferExit: FAILED (TRANSFER EXIT REQUEST) !!");

      (void) unsetSysAdapterListener<dia_IDataDownloadListener>(this);

      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(retCode));
   }

   // Wait for update on listener interface
}

//----------------------------------------------------------------------

void
dia_SrvHandlerGenericRequestTransferExit::vOnTransferExitUpdate ( void )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericRequestTransferExit::vOnTransferExitUpdate");

   (void) unsetSysAdapterListener<dia_IDataDownloadListener>(this);

   // Sending back the positive answer
   DIA_TR_INF("dia_SrvHandlerGenericRequestTransferExit: SUCCEEDED");
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(1);
   vResReadyAndQuit();
}
