/*
 * \file        dia_SrvHandlerGenericPrint2DiagnosisTrace.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Oct 14, 2014
 *
 * \copyright   Robert Bosch Car Multimedia 2014
 */
// TTFis: DIA_REQ UDS 0B 2E D0 02 48 65 6C 6C 6F 20 57 6F 72 6C 64 00
//                                ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ STRING


#ifndef __INCLUDED_DIA_SERVICE_HANDLER_GENERIC_PRINT2DIAGNOSIS_TRACE_H_
#include "dia_SrvHandlerGenericPrint2DiagnosisTrace.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif


#define DIA_MIN_INPUT_BYTES  1
#define DIA_MAX_INPUT_BYTES  230


dia_SrvHandlerGenericPrint2DiagnosisTrace::dia_SrvHandlerGenericPrint2DiagnosisTrace ()
   : dia_ServiceHandlerUDS("Print2DiagnosisTrace", 0x2E, DIA_C_U16_DID_RBCM_PRINT2DIAGNOSIS_TRACE)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericPrint2DiagnosisTrace::dia_SrvHandlerGenericPrint2DiagnosisTrace()");
}
//------------------------------------------------------------------------------

dia_SrvHandlerGenericPrint2DiagnosisTrace::~dia_SrvHandlerGenericPrint2DiagnosisTrace ()
{}

void
dia_SrvHandlerGenericPrint2DiagnosisTrace::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericPrint2DiagnosisTrace::vProcessRequest()");

   bool nonStandardAscii = false;
   bool positiveResp = false;
   bool zeroTerminated = false;
   tU16 posNA; // position of first Non-ASCII character

   const tU16 MSG_DATA_OFFSET= 4;

   // extract the data from the received message
   tU8 const* pDataBuff = oDiagMsgBuffer().u8GetBuffer();
   tU16 const dataLen = (oDiagMsgBuffer().u16GetDataLength() >= MSG_DATA_OFFSET) ? tU16(oDiagMsgBuffer().u16GetDataLength() - MSG_DATA_OFFSET): 0;

   //check if input string consists of non standard ASCII characters
   for (posNA=0; posNA<dataLen; posNA++ )
   {
      if (pDataBuff[MSG_DATA_OFFSET+posNA]>127)
      {
         nonStandardAscii = true;
         break;
      }
   }

   //check if input string is zero-terminated
   for (tU16 i=0; i<dataLen; i++ )
   {
      if (pDataBuff[MSG_DATA_OFFSET+i]==0)
      {
         zeroTerminated = true;
         break;
      }
   }

   DIA_TR_INF("dia_SrvHandlerGenericPrint2DiagnosisTrace::vProcessRequest dataLen=%d", dataLen );

   /* check input parameters */
   if (dataLen<DIA_MIN_INPUT_BYTES)
   {
      DIA_TR_INF("dia_SrvHandlerGenericPrint2DiagnosisTrace::vProcessRequest !!! ERROR NO INPUT PARAMETERS");
   }
   else if (dataLen>DIA_MAX_INPUT_BYTES)
   {
      DIA_TR_INF("dia_SrvHandlerGenericPrint2DiagnosisTrace::vProcessRequest !!! TOO MANY INPUT PARAMETERS (GT %d)", DIA_MAX_INPUT_BYTES );
   }
   else if (false==zeroTerminated)
   {
      DIA_TR_INF("dia_SrvHandlerGenericPrint2DiagnosisTrace::vProcessRequest !!! THIS IS NOT ZERO-TERMINATED STRING." );
   }
   else if (true==nonStandardAscii)
   {
      DIA_TR_INF("dia_SrvHandlerGenericPrint2DiagnosisTrace::vProcessRequest !!! NOT STANDARD ASCII CHAR FOUND: 0x%02X at pos=%d", pDataBuff[MSG_DATA_OFFSET+posNA], posNA  );
   }
   else
   {
      positiveResp = true;

      DIA_TR_ERR("%s", (const char*)&pDataBuff[MSG_DATA_OFFSET]);
   }

   if (true==positiveResp)
   {
      //send positive reply
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(3);
      vResReadyAndQuit();
   }
   else
   {
      DIA_TR_INF("dia_SrvHandlerGenericPrint2DiagnosisTrace::vProcessRequest !!! NEGATIVE RESPONSE" );

      //send negative reply
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

