/*!
 * \file       dia_SrvHandlerGenericMicPSInfoRead.h
 *
 * \brief      Service Handler for read connection status of Microphones
 *
 * \details    Connection Status is current value and power supply status.
 *             Microphone status could be delivered by RVC (A-IVI project) and AUDIO (other G3G projects).
 *
 * \component  Diagnosis
 *
 * \ingroup
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef DIA_SRVHANDLER_GENERICMICPSINFOREAD_H_
#define DIA_SRVHANDLER_GENERICMICPSINFOREAD_H_

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_LISTENER__
#include "common/interfaces/dia_IAudioListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_MICROPHONE_LISTENER__
#include "common/interfaces/dia_IMicrophoneListener.h"
#endif

class dia_SrvHandlerGenericMicPSInfoRead
   : public dia_ServiceHandlerUDS,
     public dia_IAudioListenerImpl,
     public dia_IMicrophoneListenerImpl
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_SrvHandlerGenericMicPSInfoRead);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericMicPSInfoRead);

public:
   //! class constructor
   dia_SrvHandlerGenericMicPSInfoRead ( tCString name, tU8 sid, tU16 did , dia_eMicrophoneNumber micNo );
   dia_SrvHandlerGenericMicPSInfoRead ( tCString name, tU8 sid, tU16 did );

   //! class destructor
   virtual ~dia_SrvHandlerGenericMicPSInfoRead(void);

   virtual void vProcessRequest ( const std::vector<tArgsType>& vecArgs );

   virtual void SetCurrentMeasurementImpossible(tBool currentMeasurementImpossible ) { mCurrentMeasurementImpossible = currentMeasurementImpossible; }
   virtual tBool GetCurrentMeasurementImpossible() { return mCurrentMeasurementImpossible; }

   //-------------------------------------------------------------------------
   //
   // overloaded methods from dia_IAudioListenerImpl base class
   //
   //-------------------------------------------------------------------------
   //! DEPRECATED! PLEASE USE vOnMicrophoneConnectionInfo INSTEAD.
   //! This method was kept because of backward compatibility.
   virtual void vOnMicrophonePowersupplyInfo ( const std::vector<dia_tMicrophoneStatus>& Mic_info );

   //-------------------------------------------------------------------------
   //
   // overloaded methods from dia_IMicrophoneListenerImpl base class
   //
   //-------------------------------------------------------------------------
   virtual void vOnMicrophoneConnectionInfo ( tU16 micID, const dia_MicrophoneInfo& micInfo);

   virtual void vOnTimeout ( void );

protected:
   tU16 mMicNo;
   tBool mRequest;

   // true if current measurement is impossible (e.g. because of hardware), otherwise false.
   tBool mCurrentMeasurementImpossible;
};

#endif /* DIA_SRVHANDLER_GENERICMICROPHONEPOWERSUPPLYINFO_H_ */
