/*
 * dia_SrvHandlerGenericIdentWrite.cpp
 *
 *  Created on: 04.05.2012
 *      Author: shw2abt
 */

// TTFis: DIA_REQ UDS 0B 2E 00 47 31 32 33 34 35 36 37 00

#include "dia_SrvHandlerGenericIdentWrite.h"

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#define DATA_START (tU16)3

using namespace dia;
//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentWrite::dia_SrvHandlerGenericIdentWrite ( tCString name, tU8 sid, tU8 did )
   : dia_ServiceHandlerUDS(name,sid,(tU8) did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentWrite::dia_SrvHandlerGenericIdentWrite(tCString,tU8,tU8)");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentWrite::dia_SrvHandlerGenericIdentWrite ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name,sid,did)
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentWrite::dia_SrvHandlerGenericIdentWrite(tCString,tU8,tU16)");
#endif
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentWrite::~dia_SrvHandlerGenericIdentWrite ( void )
{}

//-----------------------------------------------------------------------------


void
dia_SrvHandlerGenericIdentWrite::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentWrite::vOnProcessRequest");

   /* SrvHandler Defines according to CDD-File */
   #define MSG_DATA_OFFSET 4                        // Offset from oDiagMsgBuffer-start to 1st data-byte (e.g. MemorySize-Byte)
   /*------------------------------------------*/

   if ( !(vecArgs.size()) )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandlerGenericIdentWrite: FAILED (Property Not Available) !!");
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      return;
   }

   // extract the data from the received message
   tU8 const* pU8 = oDiagMsgBuffer().u8GetBuffer();
   tU8 u8propData[DIA_PROP_LENGTH_MAX] = {0};
   // initialize the data memory
   (void) ::memset(u8propData,0,DIA_PROP_LENGTH_MAX);

   // copy until end of msg. (max ms length == 240B) or '\0' (0x0)
   tU16 u16EleCount = 0;
   for ( ; u16EleCount < (oDiagMsgBuffer().u16GetDataLength()-MSG_DATA_OFFSET); u16EleCount++){
      if ( u16EleCount < DIA_PROP_LENGTH_MAX ) {
         u8propData[u16EleCount] = pU8[u16EleCount+MSG_DATA_OFFSET];
         //DIA_TR_INF("dia_SrvHandlerGenericIdentWrite::u8propData[%d] 0x%02x", u16EleCount, u8propData[u16EleCount]);
      }
   }

   tDiaResult retCode = validateData(u8propData,u16EleCount);

   if ( retCode != DIA_SUCCESS )
   {
      // Sending back the Negative answer
      DIA_TR_INF("dia_SrvHandlerGenericIdentWrite: FAILED (DATA VALIDATION) !!");
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(retCode));
      return;
   }

   bool writeFailed = false;
   tDiaResult setPropResult = DIA_FAILED;
   for ( tU16 i=0; i<vecArgs.size(); i++ )
   {
      tU32 propID = VoidCast<tU32>(vecArgs[i]);
      tDiaResult tmpResult = dia_setProperty(propID,u8propData,u16EleCount);
      if ( DIA_SUCCESS != tmpResult )
      {
         DIA_TR_ERR("dia_SrvHandlerGenericIdentWrite: set ERROR CODE 0x%08X.", tmpResult);
         writeFailed = true;
         setPropResult = tmpResult;
      }
   }

   if ( writeFailed )
   {
      // Sending back the Negative answer
      DIA_TR_ERR("dia_SrvHandlerGenericIdentWrite: FAILED (WRITE DATA TO PERSISTENT MEMORY) !!");
      vSendNegativeResponse( (DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT==setPropResult)? DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT: DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      return;
   }

   // Sending back the positive answer
   DIA_TR_INF("dia_SrvHandlerGenericIdentWrite: SUCCEEDED");
   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START);
   vResReadyAndQuit();
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SrvHandlerGenericIdentWrite::checkLength ( tU16 length, tU16 minValue, tU16 maxValue )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentWrite::checkLength");
   return ((length >= minValue) && (length <= maxValue)) ? DIA_SUCCESS : DIA_FAILED;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_SrvHandlerGenericIdentWrite::checkASCII ( const tU8 data[], tU16 length, tU16 offset, tU16 numBytes )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentWrite::checkASCII");

   tDiaResult retCode = DIA_SUCCESS;

   if ( (offset >= length) || ((offset + numBytes) > length) ) return DIA_FAILED;

   for ( tU16 i=offset; i<(offset+numBytes); i++ )
   {
      if ( data[i] > 127 )
      {
         retCode = DIA_FAILED;
         break;
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------

//tDiaResult
//dia_SrvHandlerGenericIdentWrite::checkBCD ( const tU8 data[], tU16 length, tU16 offset, tU16 count )
//{
//   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentWrite::checkASCII");
//
//   tDiaResult retCode = DIA_SUCCESS;
//
//   if ( (offset >= length) || ((offset + count) > length) ) return DIA_FAILED;
//
//   for ( tU16 i=offset; i<(offset+count); i++ )
//   {
//      if ( data[i] > 127 )
//      {
//         retCode = DIA_FAILED;
//         break;
//      }
//   }
//
//   return retCode;
//}
//
//-----------------------------------------------------------------------------

tDiaResult
dia_SrvHandlerGenericIdentWrite::checkZeroTerminated ( const tU8 data[], tU16 length )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentWrite::checkZeroTerminated");

   tDiaResult retCode = DIA_FAILED;

   for ( tU16 i=0; i<length; i++ )
   {
      if ( data[i] == '\0' )
      {
         retCode = DIA_SUCCESS;
         break;
      }
   }

   return retCode;
}
