/*
 * dia_SrvHandlerGenericIdentADCRead.cpp
 *
 *  Created on: 27.04.2012
 *      Author:
 */

// TTFis: DIA_REQ UDS 04 22 00 47

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#include "dia_SrvHandlerGenericIdentADCRead.h"
//#include "project/services/customer/dia_ReadSupportedLocalIdentifiers.h"

#define DATA_START 3
using namespace dia;
//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentADCRead::dia_SrvHandlerGenericIdentADCRead ( tCString name, tU8 sid, tU8 did )
   : dia_ServiceHandlerUDS(name,sid,(tU8) did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentADCRead::dia_SrvHandlerGenericIdentADCRead(tCString,tU8,tU8)");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentADCRead::dia_SrvHandlerGenericIdentADCRead ( tCString name, tU8 sid, tU16 did )
   : dia_ServiceHandlerUDS(name,sid,did)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentADCRead::dia_SrvHandlerGenericIdentADCRead(tCString,tU8,tU16)");
}
//-----------------------------------------------------------------------------

dia_SrvHandlerGenericIdentADCRead::~dia_SrvHandlerGenericIdentADCRead ( tVoid )
{}

//-----------------------------------------------------------------------------

tVoid
dia_SrvHandlerGenericIdentADCRead::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericIdentADCRead::vOnProcessRequest");

   if ( !vecArgs.size() )
   {
      DIA_TR_INF("dia_SrvHandlerGenericIdentADCRead::INVALID PARAMETERS !!");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }

   tU32 propID = VoidCast<tU32>(vecArgs[0]);
   tU32 propValue = 0;

   // received message
   for ( tU16 i = 0; i < oDiagMsgBuffer().u16GetDataLength(); i++){\
   	DIA_TR_INF("dia_SrvHandlerGenericIdentADCRead::input-buffer[%d] 0x%02x",i,oDiagMsgBuffer().u8GetData(i) );
   }

   // data memory
   tU8 u8data[DIA_PROP_LENGTH_MAX] = {0};
   // initialize the data memory
   (tVoid) ::memset(u8data,0,DIA_PROP_LENGTH_MAX);

   tDiaResult retCode = getInstanceOfConfigManager()->getProperty(propID,propValue);

   if ( retCode == DIA_SUCCESS )
   {
      // Sending back the positive answer

      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START+2);
      //Mask the Data to a 12 Bit Value
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START+0, (tU8)(propValue >>8 & 0x0fff));
      (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START+1, (tU8)propValue);

      vResReadyAndQuit();
   }
   else
   {
      DIA_TR_INF("dia_SrvHandlerGenericIdentADCRead::ReadDataByIdentifier FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}


