/*
 * \file        dia_SrvHandlerGenericECUResetsByResetType.h
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Apr 22, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_ECURESETS_BY_RESET_TYPE__
#define __INCLUDED_DIA_SRVHANDLER_GENERIC_ECURESETS_BY_RESET_TYPE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include <common/framework/protocols/uds/dia_ServiceHandlerUDS.h>
#endif

#ifndef __INCLUDED_DIA_ECURESET_MANAGER__
#include "common/framework/protocols/uds/ecureset/dia_EcuResetManager.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ECU_RESET_LISTENER__
#include <common/interfaces/dia_IEcuResetListener.h>
#endif

//-----------------------------------------------------------------------------

class dia_SrvHandlerGenericECUResetsByResetType
    : public dia_ServiceHandlerUDS,
      public dia_IEcuResetListener
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_SrvHandlerGenericECUResetsByResetType);
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_SrvHandlerGenericECUResetsByResetType);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SrvHandlerGenericECUResetsByResetType);

public:
   //
   // Overloaded methods from dia_ServiceHandlerUDS
   //
   //! a timeout has occurred
   virtual void vOnTimeout ( void );

   //! Receives incoming messages and forward them
   virtual void vOnReqRx ( void );
   //! called to request the lookup keys for this service
   virtual tDiaResult makeLookupKeys ( std::vector<dia_LookupKey*>& keys );

   //! retrieve the value of the processing timeout
   virtual tU32  getTimeoutValue ( void ) const;

   //
   // Overloaded methods of dia_IEcuResetListener
   //
   virtual void vOnEcuResetUpdate ( dia_EcuResetPlugin* pEcuResetPlugin, tDiaResult result );

protected:

   dia_EcuResetManager* mpEcuResetMgr;

   //! UID of last rework ECU reset handler
   dia_UID mUID;
};

#endif
