/*
 * \file        dia_SrvHandlerGenericECUResetsByResetType.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Apr 22, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_LOOKUPKEY__
#include <common/framework/engine/dia_LookupKey.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_ECURESET__
#include "common/framework/protocols/uds/ecureset/dia_EcuReset.h"
#endif

// include own class
#include "dia_SrvHandlerGenericECUResetsByResetType.h"

using namespace std;

// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_SrvHandlerGenericECUResetsByResetType)

#ifndef __DIA_UNIT_TESTING__

dia_SrvHandlerGenericECUResetsByResetType*
getInstanceOfSrvHandlerGenericECUResetsByResetType ( void )
{
   DIA_TR_INF("getInstanceOfSrvHandlerGenericECUResetsByResetType() not for UT");
   return dia_SrvHandlerGenericECUResetsByResetType::getInstance();
}

void
releaseInstanceOfSrvHandlerGenericECUResetsByResetType ( void )
{
   DIA_TR_INF("getInstanceOfSrvHandlerGenericECUResetsByResetType() not for UT");
   return dia_SrvHandlerGenericECUResetsByResetType::deleteInstance();
}
#endif

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericECUResetsByResetType::dia_SrvHandlerGenericECUResetsByResetType ( void )
   : dia_ServiceHandlerUDS("dia_SrvHandlerGenericECUResetsByResetType",DIA_C_U8_UDS_SID_ECU_RESET),
     mpEcuResetMgr(getInstanceOfEcuResetManager()),mUID(0)
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericECUResetsByResetType::dia_SrvHandlerGenericECUResetsByResetType()");
}

//------------------------------------------------------------------------------

dia_SrvHandlerGenericECUResetsByResetType::~dia_SrvHandlerGenericECUResetsByResetType ( void )
{
   mpEcuResetMgr = 0;
}

//------------------------------------------------------------------------------

tU32
dia_SrvHandlerGenericECUResetsByResetType::getTimeoutValue ( void ) const
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericECUResetsByResetType::getTimeoutValue()");

   tU32 maxTime = DIA_C_U32_MAX_PROCESSING_TIME_SERVICE_UDS;

   // extract the identifier from the message buffer and convert to the corresponding reset type
   dia_ResetType resetType = oDiagMsgBuffer().u8GetSubServiceId();

   dia_EcuResetPlugin* pEcuSrvHandler = mpEcuResetMgr->getResetSrvHandler(resetType);

   if ( pEcuSrvHandler )
   {
      maxTime = pEcuSrvHandler->getMaxProcessingTime();
   }

   DIA_TR_INF("##### ECU_RESET TIMEOUT VALUE SET TO %d ms", maxTime);

   return maxTime;
}

//------------------------------------------------------------------------------

void
dia_SrvHandlerGenericECUResetsByResetType::vOnReqRx ( void )
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericECUResetsByResetType::vOnReqRx()");

   // check if we have received the right length
   tU16 dataLength = oDiagMsgBuffer().u16GetDataLength();

   if ( dataLength >  3 )
   {
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT));
      return;
   }

   // extract the identifier from the message buffer and convert to the corresponding reset type
   dia_ResetType resetType = oDiagMsgBuffer().u8GetSubServiceId();

   dia_EcuResetPlugin* pEcuSrvHandler = mpEcuResetMgr->getResetSrvHandler(resetType);

   if ( (!pEcuSrvHandler) || (pEcuSrvHandler->getUID() == 0) )
   {
      DIA_TR_ERR("dia_SrvHandlerGenericECUResetsByResetType::vOnReqRx: UNKNOWN RESET TYPE !!");
      vSendNegativeResponse( getInstanceOfFactory()->makeNRC(DIA_E_OUT_OF_RANGE) );
      return;
   }

   tDiaResetResponse retVal = pEcuSrvHandler->handleRequest();

   // results for this request
   vector<tU8> results;

   switch(retVal)
   {
      case DIA_RESET_FORCE_POS_RESPONSE:
         DIA_TR_INF("dia_SrvHandlerGenericECUResetsByResetType::vOnReqRx: DIA_RESET_FORCE_POS_RESPONSE");
         results.push_back(static_cast<tU8>(resetType));
         vSendPositiveResponse(static_cast<tU16>(results.size() + 1), &results);
      break;

      case DIA_RESET_WAIT_FOR_SPM:
         DIA_TR_INF("dia_SrvHandlerGenericECUResetsByResetType::vOnReqRx: DIA_RESET_WAIT_FOR_SPM");
         /* response will come later to function vOnEcuResetUpdate */
         (tVoid) setSysAdapterListener<dia_IEcuResetListener>(this);

         /* response must have the same UID */
         mUID = pEcuSrvHandler->getUID();
      break;

      case DIA_RESET_NEG_RESPONSE:
      default:
         DIA_TR_ERR("dia_SrvHandlerGenericECUResetsByResetType::vOnReqRx: DIA_E_CONDITIONS_NOT_CORRECT !!");
         vSendNegativeResponse( getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT) );
      break;
   }
}

//------------------------------------------------------------------------------

void
dia_SrvHandlerGenericECUResetsByResetType::vOnEcuResetUpdate ( dia_EcuResetPlugin* pEcuResetPlugin, tDiaResult result )
{
   dia_tclFnctTrace oTrace("dia_SrvHandlerGenericECUResetsByResetType::vOnEcuResetUpdate()");

   DIA_TR_INF("result is %s", ( DIA_SUCCESS==result ? "DIA_SUCCESS": "DIA_FAILED") );

   if (NULL==pEcuResetPlugin)
   {
      DIA_TR_ERR("pEcuResetPlugin is NULL." );
      return;
   }

   if ( pEcuResetPlugin->getUID() == mUID )
   {
      (void) unsetSysAdapterListener<dia_IEcuResetListener>(this);

      if ( DIA_SUCCESS==result )
      {
         DIA_TR_INF("Send positive reply.");

         // results for this request
         vector<tU8> results;
         results.push_back(static_cast<tU8>(pEcuResetPlugin->getResetType()));
         vSendPositiveResponse(static_cast<tU16>(results.size() + 1), &results);
      }
      else
      {
         DIA_TR_INF("Send negative reply.");
         vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      }
   }
   else
   {
      DIA_TR_ERR("pEcuResetPlugin->getUID()=0x%08X and mUID=0x%08X are different.", pEcuResetPlugin->getUID(), mUID );
   }
}

//------------------------------------------------------------------------------

tDiaResult
dia_SrvHandlerGenericECUResetsByResetType::makeLookupKeys ( std::vector<dia_LookupKey*>& keys )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericECUResetsByResetType::makeLookupKeys");

   if ( mLookupKeys.empty() )
   {
      const std::map<dia_UID,dia_EcuResetPlugin*>& resetRep = getInstanceOfEcuResetManager()->getUIDResetSrvHandlers();

      DIA_TR_INF("Size of ECU reset service handler list = %zu", resetRep.size());

      std::map<dia_UID,dia_EcuResetPlugin*>::const_iterator cIter = resetRep.begin();
      for ( ; cIter != resetRep.end(); ++cIter )
      {
         tU16 did = cIter->second->getDID();
         mLookupKeys.push_back( OSAL_NEW dia_LookupKey( DIA_C_U8_UDS_SID_ECU_RESET, (tU8) did, DIA_C_U16_SRVDISPATCHER_KEY_LENGTH_NOT_USED) );
      }
   }

   keys = mLookupKeys;

   return DIA_SUCCESS;
}

void
dia_SrvHandlerGenericECUResetsByResetType::vOnTimeout ( void )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericECUResetsByResetType::vOnTimeout");

   (tVoid) unsetSysAdapterListener<dia_IEcuResetListener>(this);
   oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   vResReadyAndQuit();
}
