/*
 * dia_SrvHandlerGenericClearFaultMemory.cpp
 *
 *  Created on: 15.06.2012
 *      Author: shw2abt
 */

// TTFis:\> DIA_REQ UDS 05 14 FF FF FF

#include "dia_SrvHandlerGenericClearFaultMemory.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_TEST__
#include "common/framework/test/dia_common_test.h"
#endif

//#define DATA_START 3
#define DATA_LENGTH 5
using namespace dia;
//-----------------------------------------------------------------------------

dia_SrvHandlerGenericClearFaultMemory::dia_SrvHandlerGenericClearFaultMemory ( void )
    : dia_ServiceHandlerUDS("dia_SrvHandlerGenericClearFaultMemory",DIA_C_U8_UDS_SID_CLEAR_DIAG_INFO ),
      m_u32GroupOfDtc(0)
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericClearFaultMemory::dia_SrvHandlerGenericClearFaultMemory(void)");
}

//-----------------------------------------------------------------------------

dia_SrvHandlerGenericClearFaultMemory::~dia_SrvHandlerGenericClearFaultMemory ( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_SrvHandlerGenericClearFaultMemory::~dia_SrvHandlerGenericClearFaultMemory !!!");
        NORMAL_M_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

// Befehlsrichtung
void
dia_SrvHandlerGenericClearFaultMemory::vProcessRequest ( const std::vector<tArgsType>& vecArgs )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericClearFaultMemory::vProcessRequest");

   tBool errorDetected = TRUE;
   tU16 dataLen = oDiagMsgBuffer().u16GetDataLength();

   if ( dataLen != DATA_LENGTH )
   {
      DIA_TR_ERR("dia_SrvHandlerGenericClearFaultMemory::vProcessRequest dataLen %d is unequal %d", dataLen, DATA_LENGTH);
      vSendNegativeResponse(DIA_E_U8_UDS_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT);
      return;
   }

   m_vecGroups.clear();

   if (vecArgs.size() == 0)
   {
      //Default group is "1"
      m_vecGroups.push_back(1);
   }
   else
   {
      for (tU32 i = 0; i < vecArgs.size(); i++)
      {
         tU8 u8Group = VoidCast<tU8>(vecArgs[i]);
         m_vecGroups.push_back(u8Group);
      }
   }

   m_u32GroupOfDtc = oDiagMsgBuffer().u8GetData(2) << 16;
   m_u32GroupOfDtc |= oDiagMsgBuffer().u8GetData(3) << 8;
   m_u32GroupOfDtc |= oDiagMsgBuffer().u8GetData(4);

   dia_IErrorLog* pInterface = 0;

   if ((querySysAdapterInterface<dia_IErrorLog>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      (void) setSysAdapterListener<dia_IErrorLogListener>(this);

      size_t iGroup = m_vecGroups.size();
      if (iGroup != 0)
      {
         if (pInterface->clearDTC(m_vecGroups[iGroup-1], m_u32GroupOfDtc) == DIA_SUCCESS)
         {
            errorDetected = FALSE;
         }
         else
         {
            DIA_TR_ERR("dia_SrvHandlerGenericClearFaultMemory::vProcessRequest ---  SEND TO DIAGLOG FAILED!!!!");
         }
      }
      else
      {
         DIA_TR_ERR("dia_SrvHandlerGenericClearFaultMemory::vProcessRequest --- NO GROUP TO CLEAR!!!!");
      }
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}

//-------------------------------------------------------------------------------

// Melderichtung
void
dia_SrvHandlerGenericClearFaultMemory::vOnClearResult ( )
{
   dia_tclFnctTrace trc("dia_SrvHandlerGenericClearFaultMemory::vOnClearResult");

   m_vecGroups.pop_back();

   size_t iGroup = m_vecGroups.size();
   if (iGroup != 0)
   {
      dia_IErrorLog* pInterface = 0;
      if ((querySysAdapterInterface<dia_IErrorLog>(&pInterface) != DIA_SUCCESS) || !pInterface
            || (pInterface->clearDTC(m_vecGroups[iGroup-1], m_u32GroupOfDtc) != DIA_SUCCESS))
      {
         (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);
         DIA_TR_ERR("dia_SrvHandlerGenericClearFaultMemory::vProcessRequest ---  SEND TO DIAGLOG FAILED!!!!");
         vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
      }
   }
   else
   {
      (void) unsetSysAdapterListener<dia_IErrorLogListener>(this);

      DIA_TR_INF("dia_SrvHandlerGenericClearFaultMemory::vOnClearResult SUCCESSFUL");
      vSendPositiveResponse(1);

//kaa1hi: 2016-01-05 To be clarified why it was commented out on 2015-01-08 by Lars Plischke
//#if 0 // done by diaglog callback (MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT)
      // Run the startup tests.
      dia_TestController* pTestCtrl = getInstanceOfTestController();
      if (pTestCtrl)
      {
         (void) pTestCtrl->runTests(DIA_EN_TESTCONDITION_ERROR_MEMORY_RESET);
      }
//#endif
   }
}

//-------------------------------------------------------------------------------

void
dia_SrvHandlerGenericClearFaultMemory::vOnClearError(tU32 u32Error)
{
   dia_tclFnctTrace trc( "dia_SrvHandlerGenericClearFaultMemory::vOnClearError");

   unsetSysAdapterListener<dia_IErrorLogListener>(this);
   DIA_TR_ERR( "dia_SrvHandlerGenericClearFaultMemory::vProcessRequest => ERROR: %x",u32Error);
   if(u32Error == EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE)
   {
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_OUT_OF_RANGE));
   }
   else
   {
      vSendNegativeResponse(getInstanceOfFactory()->makeNRC(DIA_E_CONDITIONS_NOT_CORRECT));
   }
}
