/**
 * \file      dia_RoutineCtrlGetProcStatMByProcessname.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    fan4hi
 * \date      Jan 29, 2018
 *
 * \copyright Robert Bosch Car Multimedia 2018
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GET_PROC_STATM_BY_PROCESSNAME_H_
#include "common/services/uds/generic/dia_RoutineCtrlGetProcStatMByProcessname.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif

#ifndef __INCLUDED_DIA_PROC_INFO_H_
#include "common/framework/utils/dia_ProcInfo.h"
#endif

namespace dia
{

RoutineCtrlGetProcStatMByProcessname::RoutineCtrlGetProcStatMByProcessname(tCString name, tU16 udsID, dia_eRoutineID routineID)
   : dia_Routine(name, udsID, routineID, DIA_EN_RTCTRL_TYPE_SHORT_TERM)
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);
}

//------------------------------------------------------------------------------

RoutineCtrlGetProcStatMByProcessname::~RoutineCtrlGetProcStatMByProcessname()
{
}

//------------------------------------------------------------------------------

tDiaResult RoutineCtrlGetProcStatMByProcessname::start(std::vector<tU8>& params, tU8 /*timerValue*/)
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

   ProcInfo                   procinfo;
   int                        i, pid=-1;
   std::vector<tU8>::iterator iter;
   bool                       success=false;
   char                       procname[PROCINFO_PROC_NAME_MAX+1];
   static const char          format[]=
   {
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_PAGES,   4),   // size
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_PAGES,   4),   // resident
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_PAGES,   4),   // shared
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_PAGES,   4),   // text
      PROCINFOFORMAT_SKIP, // lib
      PROCINFOFORMAT_ENTRY(PROCINFOFORMAT_PAGES,   4),   // data
      PROCINFOFORMAT_END_SEQUENCE,
   };

   if(params.size()>PROCINFO_PROC_NAME_MAX)
      return DIA_FAILED; // CHECKME: Is this the correct error code? Is there anything else to do?
   else
   {
      for(i=0, iter=params.begin(); iter!=params.end(); i++, ++iter)
         procname[i]=*iter;
      procname[i]=0;

      if(!procname[0])
         return DIA_FAILED; // CHECKME: Is this the correct error code? Is there anything else to do?
      else
      {
         // NOTE: There might be multiple instances of a process. For now, we check just the first one.
         if((pid=procinfo.GetPID(procname))>=0)
         {
            mResults.clear();
            if(procinfo.ParseStatMValues(mResults, pid, format))
               success=true;
         }
      }
   }

   // Variable for Service Handler Framework that this job is done //! indicate that we are done
   mIsResultReady=TRUE;

   if(success==true)
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   else
      return DIA_FAILED; // CHECKME: Is this the correct error code? Is there anything else to do?

   return DIA_SUCCESS;
}

tDiaResult RoutineCtrlGetProcStatMByProcessname::requestResult(std::vector<tU8>& results)
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

   results.push_back(mapStatus2UDSResult());
   results.insert(results.end(), mResults.begin(), mResults.end());

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

void RoutineCtrlGetProcStatMByProcessname::vOnServiceTimeout(void)
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

   eSetStatus(DIA_EN_RTCTRL_STATUS_TIMED_OUT);

#ifndef __DIA_UNIT_TESTING__
   dia_RoutineCtrlManager* pRTCtrlMgr=getInstanceOfRoutineControlManager();

   if(pRTCtrlMgr)
   {
       pRTCtrlMgr->vOnRoutineUpdate(*this);
   }
#endif
}

} // namespace dia
