/*
 * dia_RoutineCtrlGenericCalculateConfigFingerprint.h
 *
 *  Created on: 18.06.2015
 *      Author: bhs1hi
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GENERIC_CALCULATE_CONFIG_FINGERPRINT__
#define __INCLUDED_DIA_ROUTINE_CTRL_GENERIC_CALCULATE_CONFIG_FINGERPRINT__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_LONGTERM__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineLong.h"
#endif


namespace dia
{

class RoutineCtrlGenericCalculateConfigFingerprint : public dia_Routine
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RoutineCtrlGenericCalculateConfigFingerprint);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlGenericCalculateConfigFingerprint);

public:

   RoutineCtrlGenericCalculateConfigFingerprint ( tCString name, tU16 udsID );
   RoutineCtrlGenericCalculateConfigFingerprint ( tCString name, tU16 udsID, const dia_FingerprintInfo fingerprintData[], const tU16 numOfInfo );

   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );
   //! handle timeout from UDS session object
   virtual void vOnServiceTimeout ( void );
   //! load fingerprint info data
   tDiaResult loadFingerprintInfo ( const dia_FingerprintInfo fingerprintData[], const tU16 numOfInfo );

protected:
   //! DID
   tU16 mDID;
   //! repository of dia_FingerprintInfo
   std::vector<dia_FingerprintInfo> mFingerprintInfoRep;
};

} //namespace dia

#endif /* __INCLUDED_DIA_ROUTINE_CTRL_GENERIC_CALCULATE_CONFIG_FINGERPRINT__ */
