/*
 * dia_RoutineCtrlExecuteSystemCommand.h
 *
 *  Created on: 29.02.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_EXECUTE_SYSTEM_COMMAND__
#define __INCLUDED_DIA_ROUTINE_CTRL_EXECUTE_SYSTEM_COMMAND__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

namespace dia
{

class RoutineCtrlExecuteSystemCommand
   : public dia_Routine
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlExecuteSystemCommand);

   enum enRoutineResponseStatus
   {
      ROUTINE_OK = 0,
      ROUTINE_NOK,
      ROUTINE_ABORT,
      ROUTINE_RUNNING,
      ROUTINE_STOPPED
   };

public:
   RoutineCtrlExecuteSystemCommand ( tCString name, tU16 udsID, const std::string& cmdName, dia_eRoutineType routineType=DIA_EN_RTCTRL_TYPE_SHORT_TERM );
   RoutineCtrlExecuteSystemCommand ( const std::string& name, tU16 udsID, const std::string& cmdName, dia_eRoutineType routineType=DIA_EN_RTCTRL_TYPE_SHORT_TERM );
   virtual ~RoutineCtrlExecuteSystemCommand ( void );

   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   virtual tDiaResult stop ( std::vector<tU8>& params); //lint !e1735 Info: verified that same default parameter is used as in base class
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   void setCommand ( const std::string& cmdName ) { mFullCommandName = cmdName; }

protected:
   //! deprecated constructor without implementation
   RoutineCtrlExecuteSystemCommand ( void );

   //! setup (create objects,...)
   virtual tDiaResult setup ( void );
   //! tear down (destroy objects,...)
   //lint -sem(dia::RoutineCtrlExecuteSystemCommand::tearDown,cleanup)
   virtual tDiaResult tearDown ( void );

   //! initialize the routine before we start processing
   virtual void vInitialize ( void );
   //! kill the running child processes
   virtual void killChildProcess ( pid_t pid ) const;
   //! evaluate the parameters passed to this start routine method
   virtual tDiaResult evaluateStartParameters ( std::vector<tU8>& /*params*/ ) { return DIA_SUCCESS; }
   //! evaluate the parameters passed to this start routine method
   virtual tDiaResult evaluateStopParameters ( std::vector<tU8>& /*params*/ ) { return DIA_SUCCESS; }
   //! evaluate the exit code
   virtual tDiaResult evaluateCommandResponse ( int /*exitCode*/ ) { return DIA_SUCCESS; }

   virtual tDiaResult getCommandArguments ( std::vector<std::string>& /*argv*/) { return DIA_SUCCESS; }

   virtual bool isExisting ( void );
   bool isRunning  ( void );

   virtual void setSystemCommandArguments ( void );

   virtual void executeStartSystemCommand ( void );
   virtual void startSystemCommand ( void );
   virtual void onSystemCommandStarted ( void );
   virtual void onSystemCommandStartupFailed ( void );

   virtual void executeStopSystemCommand ( void );
   virtual void stopSystemCommand ( void );

   virtual void executeRequestSystemCommandResults ( void );
   virtual void requestSystemCommandResults ( void );

protected:
   std::string mFullCommandName;
   enRoutineResponseStatus mResponseStatus;
   pid_t mChildProcessID;
   bool  mIsRunning;
   tDiaResult mErrorCode;
   std::vector<std::string> mSystemCommandArgs;
   tU8 mResultStatus;
};

}

#endif /* __INCLUDED_DIA_ROUTINE_CTRL_EXECUTE_SYSTEM_COMMAND__ */
