/*!
 * \file       dia_RoutineCtrlEcho.h
 *
 * \brief      Routing Control that sends back answer with content and delay defined in request-message
 *
 * \details    
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_ROUTINE_CTRL_ECHO__
#define __INCLUDED_DIA_ROUTINE_CTRL_ECHO__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include "common/framework/application/dia_Lock.h"
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

#ifndef __INCLUDED_DIA_DIAGSESSION__
#include "common/depricated/dia_tclDiagSession.h"
#endif

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif


#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"

#include "common/framework/application/dia_SelfMsg.h"
#include "common/framework/application/dia_SelfTimer.h"


namespace dia {










class RoutineCtrlEcho : public dia_Routine
{
   struct MsgTimeout {
      MsgTimeout() {
         ScopeTrace oTrace("MsgTimeout::MsgTimeout()");
      }
      ~MsgTimeout() {
         ScopeTrace oTrace("MsgTimeout::~MsgTimeout()");
      }
   };
   public:
   RoutineCtrlEcho();

   virtual tDiaResult start ( std::vector<tU8>& params, tU8 /*timerValue*/ );

   virtual tDiaResult vOnWaitDone ( MsgTimeout msg );
   
   virtual tDiaResult requestResult(std::vector<tU8>& results);

   void onTimeout(MsgTimeout *msg);
   
private: 
   RefCounter mRefCounter;
   SelfTimer<RoutineCtrlEcho, MsgTimeout> mSelfTimer;
};


}
#endif

