/*!
 * \file       dia_RoutineCtrlEcho.cpp
 *
 * \brief      Routing Control that sends back answer with content and delay defined in request-message
 *
 * \details    
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_ROUTINE_CTRL_ECHO__
#include "dia_RoutineCtrlEcho.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif


namespace dia {

RoutineCtrlEcho::RoutineCtrlEcho():
   dia_Routine("RoutineCtrlEcho", 
               DIA_C_U16_DID_RBCM_RTCTRL_ECHO, 
               DIA_EN_RTCTRL_ID_ECHO,
               DIA_EN_RTCTRL_TYPE_SHORT_TERM,
               DIA_EN_RTCTRL_MONITORING_MODE_ENABLED),
   mSelfTimer(this, this->mRefCounter) 
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

};


tDiaResult RoutineCtrlEcho::start ( std::vector<tU8>& params, tU8 /*timerValue*/ ) {
   ScopeTrace oTrace(__PRETTY_FUNCTION__);
   /*
     parameters are optional:
     0: result-code, default 0
     1: timeout in seconds, default 0
     2: payload, special case 0xFF: next 3 bytes are answer len, otherwise complete payload will be added to response
     2: FF
     3: len0
     4: len1
     5: len2
    */

   DIA_TR_INF("RoutineCtrlEcho:numParams=%u", (uint32_t)params.size());
   setResultReady(false);

   std::vector<tU8>& params2=params;
   if (!params2.size()) {
      params2.push_back(0x00);
   }
   uint8_t udsResCode=params2[0];
   DIA_TR_INF("RoutineCtrlEcho:udsResCode=0x%02x", udsResCode);
   uint32_t numParams=(uint32_t)params2.size();
   uint32_t numEchoBytes=numParams;

   if (numParams >= 6 && params2[2]==0xFF) {
      numEchoBytes=(uint32_t)((params2[3]<< 16) + (params2[3]<< 8) + (params2[5]));
   }
   DIA_TR_INF("RoutineCtrlEcho:numEchoBytes=%u", numEchoBytes);
   // skip first byte that was the optional result-code
   for (uint32_t i = 0; i<numEchoBytes;++i) {
      if (i<params2.size()) { 
         mResults.push_back(params2[i]);
      }
      else {
         mResults.push_back(0);
      }
   }

   uint8_t durationSeconds=0;
   if (numParams >= 2) {
      durationSeconds=params2[1];
   }
   DIA_TR_INF("RoutineCtrlEcho:durationSeconds=%u!", durationSeconds);

   MsgTimeout msg;
   if (durationSeconds) {

      mSelfTimer.start(durationSeconds * 1000);

      DIA_TR_INF("RoutineCtrlEcho:timer started");
   }
   else {
      vOnWaitDone(msg);
   }
   return DIA_SUCCESS;
}


tDiaResult RoutineCtrlEcho::vOnWaitDone ( MsgTimeout msg ) {
   ScopeTrace oTrace(__PRETTY_FUNCTION__);
   onTimeout(&msg);
   return DIA_SUCCESS;
}

tDiaResult RoutineCtrlEcho::requestResult(std::vector<tU8>& results) {
   ScopeTrace oTrace(__PRETTY_FUNCTION__);
   DIA_TR_INF("RoutineCtrlEcho::onTimeout requestResult()");
   results.insert(results.end(), mResults.begin(), mResults.end());
   return DIA_SUCCESS;
}

void RoutineCtrlEcho::onTimeout(MsgTimeout * /* msg */) {
   ScopeTrace oTrace(__PRETTY_FUNCTION__);
   DIA_TR_INF("RoutineCtrlEcho::onTimeout mResults[0]=0x%02x", mResults[0]);
   
   eSetStatus(mResults[0] ? DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK : DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   setResultReady();
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}


}
