/**
 * \file      dia_RoutineCtrlEMPrint2Trace.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    kaa1hi
 * \date      Oct 21, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2014
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_EM_PRINT_2_TRACE_H_
#define __INCLUDED_DIA_ROUTINE_CTRL_EM_PRINT_2_TRACE_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"    //needed by class dia_RoutineCtrlEMPrint2Trace
#endif

namespace dia
{

class RoutineCtrlEMPrint2Trace
   : public dia_Routine
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RoutineCtrlEMPrint2Trace);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlEMPrint2Trace);

public:
   RoutineCtrlEMPrint2Trace (tCString name, tU16 udsID, dia_eRoutineID routineID);
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );
   //! handle timeout from UDS session object
   virtual void vOnServiceTimeout ( void );
   //! retrieve the value of the maximum processing time in ms
   virtual tU32 getMaxProcessingTime ( void ) const { return 40000; }
};

} //namespace dia

#endif /* __INCLUDED_DIA_ROUTINE_CTRL_EM_PRINT_2_TRACE_H_ */
