/**
 * \file      dia_RoutineCtrlEMErase.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    kaa1hi
 * \date      Oct 21, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2014
 */

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_EM_ERASE_H_
#include "common/services/uds/generic/dia_RoutineCtrlEMErase.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif

namespace dia
{

RoutineCtrlEMErase::RoutineCtrlEMErase (tCString name, tU16 udsID, dia_eRoutineID routineID)
   : dia_Routine(name, udsID, routineID, DIA_EN_RTCTRL_TYPE_SHORT_TERM)
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);
}

//------------------------------------------------------------------------------

RoutineCtrlEMErase::~RoutineCtrlEMErase ( void )
{
}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlEMErase::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);
   bool success = false;

   // prepare processing of the routine
   vInitialize();

   size_t numInBytes = params.size();

   if (0!=numInBytes)
   {
      DIA_TR_ERR("dia_RoutineCtrlEMErase::start numInBytes = %zu", numInBytes );
      return DIA_FAILED;
   }

   OSAL_tIODescriptor fd;

   fd = OSAL_IOOpen(OSAL_C_STRING_DEVICE_PRM, OSAL_EN_READONLY);
   if (OSAL_ERROR==fd)
   {
      DIA_TR_ERR("OSAL_IOOpen FAILED");
   }
   else
   {
      tS32 s32Dummy = 0;
      if (OSAL_ERROR==OSAL_s32IOControl(fd, OSAL_C_S32_IOCTRL_PRM_TRIGGER_DEL_ERRMEM, s32Dummy))
      {
         DIA_TR_ERR("OSAL_s32IOControl OSAL_C_S32_IOCTRL_PRM_TRIGGER_DEL_ERRMEM=0x%0x FAILED", OSAL_C_S32_IOCTRL_PRM_TRIGGER_DEL_ERRMEM);
      }
      else
      {
         DIA_TR_INF("OSAL_s32IOControl OSAL_C_S32_IOCTRL_PRM_TRIGGER_DEL_ERRMEM=0x%0x succeeded", OSAL_C_S32_IOCTRL_PRM_TRIGGER_DEL_ERRMEM );
         success = true;
      }

      if (OSAL_OK!=OSAL_s32IOClose(fd))
      {
         DIA_TR_ERR("OSAL_s32IOClose(0x%lx) FAILED", (unsigned long)fd);
      }
   } //lint !e550: Symbol not accessed, but required to pass a valid parameter in function call


   // Variable for Service Handler Framework that this job is done //! indicate that we are done
   mIsResultReady = TRUE;

   if (success==true)
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   }
   else
   {
      DIA_TR_ERR("DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK");
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   }

   return DIA_SUCCESS;
}

tDiaResult
RoutineCtrlEMErase::requestResult( std::vector<tU8>& results )
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

   results.push_back(mapStatus2UDSResult());

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

void
RoutineCtrlEMErase::vOnServiceTimeout ( void )
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

   eSetStatus(DIA_EN_RTCTRL_STATUS_TIMED_OUT);

#ifndef __DIA_UNIT_TESTING__
   dia_RoutineCtrlManager* pRTCtrlMgr = getInstanceOfRoutineControlManager();

   if ( pRTCtrlMgr )
   {
       pRTCtrlMgr->vOnRoutineUpdate(*this);
   }
#endif
}

} // namespace dia
