/*
 * dia_NRCGenerator.cpp
 *
 *  Created on: 10.09.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_NRC_GENERATOR__
#include "dia_NRCGenerator.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

std::map<tU8,dia_NRCGenerator*> dia_NRCGenerator::mGeneratorRep;

#ifndef __DIA_UNIT_TESTING__

dia_ServiceHandler*
getInstanceOfNRCGenerator ( tDiaResult errorCode )
{
   return dia_NRCGenerator::getInstance(errorCode);
}

void
releaseInstanceOfNRCGenerator ( tDiaResult errorCode )
{
   dia_NRCGenerator::deleteInstance(errorCode);
}


void
releaseInstancesOfNRCGenerator ( void )
{
   dia_NRCGenerator::deleteInstances();
}

#endif

//-----------------------------------------------------------------------------

dia_ServiceHandler*
dia_NRCGenerator::getInstance ( tDiaResult errorCode )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_NRCGenerator::getInstance()");
   DIA_TR_INF("dia_NRCGenerator::getInstance errorCode=0x%08X", errorCode);
#endif
   tU8 nrc = getInstanceOfFactory()->makeNRC(errorCode);

   // check for existing instance and return its address if instance is found
   std::map<tU8,dia_NRCGenerator*>::iterator iter = mGeneratorRep.find(nrc);
   if ( iter != mGeneratorRep.end() ) return iter->second;

   dia_NRCGenerator* pHandler = OSAL_NEW dia_NRCGenerator(nrc);
   mGeneratorRep[nrc] = pHandler;
   return pHandler;
}

//-----------------------------------------------------------------------------

void
dia_NRCGenerator::deleteInstance ( tDiaResult errorCode )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_NRCGenerator::deleteInstance()");
   DIA_TR_INF("dia_NRCGenerator::deleteInstance errorCode=0x%08X", errorCode);
#endif
   tU8 nrc = getInstanceOfFactory()->makeNRC(errorCode);

   // check for existing instance and return its address if instance is found
   std::map<tU8,dia_NRCGenerator*>::iterator iter = mGeneratorRep.find(nrc);
   if ( iter != mGeneratorRep.end() )
   {
      dia_NRCGenerator* pObj = iter->second;
      mGeneratorRep.erase(iter);
      OSAL_DELETE pObj;
   }
}

//-----------------------------------------------------------------------------

void
dia_NRCGenerator::deleteInstances ( void )
{

   std::map<tU8,dia_NRCGenerator*>::iterator iter = mGeneratorRep.begin();
   for ( ; iter != mGeneratorRep.end(); iter++ )
   {
      OSAL_DELETE iter->second;
   }
   mGeneratorRep.clear();
}

//-----------------------------------------------------------------------------

dia_NRCGenerator::dia_NRCGenerator ( tU8 nrc )
   : dia_ServiceHandlerUDS("DIA_UDS_NRC_GENERATOR"),
     mNRC(nrc)
{
#ifdef __DIA_UNIT_TESTING__
   DIA_TR_INF("dia_NRCGenerator::dia_NRCGenerator(nrc=0x%02X)", nrc);
#endif
}

//-----------------------------------------------------------------------------

dia_NRCGenerator::~dia_NRCGenerator ( void )
{
#ifdef __DIA_UNIT_TESTING__
   DIA_TR_INF("dia_NRCGenerator::~dia_NRCGenerator(nrc=0x%02X)", mNRC);
#endif
}

//-----------------------------------------------------------------------------

void
dia_NRCGenerator::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_NRCGenerator::vProcessRequest()");

   mpEngine = 0;
   if ( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&mpEngine) != DIA_SUCCESS )
   {
      DIA_TR_ERR("##### UNABLE TO RETRIEVE POINTER TO CUSTOMER DIAGNOSIS ENGINE #####");
      return;
   }

   // assemble neg response in buffer
   oDiagMsgBuffer().vSetNegResp(mNRC);
   DIA_TR_INF("SET NEGATIVE RESPONSE CODE 0x%02x", mNRC);

   // emit ResReadyAndQuit
   vResReadyAndQuit();
};
