#ifndef __INCLUDED_DIA_IDATALOGGER__
#define __INCLUDED_DIA_IDATALOGGER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

class dia_DataLoggerRecord;
class dia_IDataLoggerItem;

class dia_IDataLogger
{
public:
   virtual ~dia_IDataLogger() {}
   virtual size_t addLoggedItem(boost::shared_ptr<dia_IDataLoggerItem>) = 0;
   virtual void getCurrentRecord(dia_DataLoggerRecord&) const = 0;
   virtual void getData(dia_DataLoggerRecord&, tS32) const = 0;
   virtual void sample() = 0;
   virtual void startLogging() = 0;
   virtual void stopLogging() = 0;
};

#endif
