/*
 * dia_HashCalculator.h
 *
 *  Created on: 26.08.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_HASH_CALCULATOR__
#define __INCLUDED_DIA_HASH_CALCULATOR__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

class dia_HashCalculator
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_HashCalculator);

public:
   //! class destructor
   virtual ~dia_HashCalculator ( void );

   //! calculate hash code of string
   virtual tU32 getHashCode ( const tU8* str, tU16 length );
   //! calculate hash code of string
   virtual tU32 getHashCode ( const std::string& str );

protected:
   //! default constructor
   dia_HashCalculator ( void );
};

dia_HashCalculator* getInstanceOfHashCalculator ( void );
void releaseInstanceOfHashCalculator ( void );

tU32 dia_getHashCodeFromString ( tCString str );
tU32 dia_getHashCodeFromString ( const std::string& str );

#endif /* __INCLUDED_DIA_HASH_CALCULATOR__ */
