/*
 * dia_HashCalculator.cpp
 *
 *  Created on: 26.08.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_HASH_CALCULATOR__
#include <common/framework/utils/dia_HashCalculator.h>
#endif

#define DIA_C_U32_HASH_CODE_INITIAL          ((tU32) 5381)
#define DIA_C_U32_HASH_CODE_MAGIC            ((tU32)   33)

DIA_IMPL_SINGLETON(dia_HashCalculator)

#ifndef __DIA_UNIT_TESTING__

dia_HashCalculator*
getInstanceOfHashCalculator ( void )
{
   return dia_HashCalculator::getInstance();
}

void
releaseInstanceOfHashCalculator ( void )
{
   return dia_HashCalculator::deleteInstance();
}

#endif

//-----------------------------------------------------------------------------

dia_HashCalculator::dia_HashCalculator ( void )
{}

//-----------------------------------------------------------------------------

dia_HashCalculator::~dia_HashCalculator ( void )
{}

//-----------------------------------------------------------------------------

tU32
dia_HashCalculator::getHashCode ( const tU8* str, tU16 length )
{
   tU32 hashValue = DIA_C_U32_HASH_CODE_INITIAL;

   for ( tU16 i=0; i < length; i++ )
   {
      hashValue = hashValue * DIA_C_U32_HASH_CODE_MAGIC + str[i];
   }

   return hashValue;

//   djb2
//   this algorithm (k=33) was first reported by dan bernstein many years ago in comp.lang.c. another version of this algorithm (now favored by bernstein) uses xor: hash(i) = hash(i - 1) * 33 ^ str[i]; the magic of number 33 (why it works better than many other constants, prime or not) has never been adequately explained.

//       unsigned long
//       hash(unsigned char *str)
//       {
//           unsigned long hash = 5381;
//           int c;
//
//           while (c = *str++)
//               hash = ((hash << 5) + hash) + c; /* hash * 33 + c */
//
//           return hash;
//       }


}

//-----------------------------------------------------------------------------

tU32
dia_HashCalculator::getHashCode ( const std::string& str )
{
   return getHashCode((const tU8*) const_cast<std::string&>(str).c_str(), (tU16) str.size());
}

//-----------------------------------------------------------------------------

tU32
dia_getHashCodeFromString ( tCString str )
{
   dia_HashCalculator* hashCalc = getInstanceOfHashCalculator();
   if ( hashCalc ) return hashCalc->getHashCode(reinterpret_cast<tU8*>(const_cast<tString>(str)), (tU16) ::strlen(str));
   DIA_TR_ERR("NO HASH CALCULATOR AVAILABLE TO CALCULATE HASH VALUE");
   return 0;
}
//-----------------------------------------------------------------------------

tU32
dia_getHashCodeFromString ( const std::string& str )
{
   return dia_getHashCodeFromString(str.c_str());
}
