/*
 * dia_CRCCalculator.h
 *
 *  Created on: 10.03.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_CRC_CALCULATOR__
#define __INCLUDED_DIA_CRC_CALCULATOR__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

enum dia_eCRCFormat
{
   DIA_EN_CRC_FORMAT_UNKNOWN = 0,
   DIA_EN_CRC_FORMAT_BIG_ENDIAN,
   DIA_EN_CRC_FORMAT_LITTLE_ENDIAN,
   DIA_EN_CRC_FORMAT_COUNT
};

class dia_CRCCalculator
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_CRCCalculator);

public:
   //! class destructor
   virtual ~dia_CRCCalculator ( void );

//   //! calculate CRC32
//   virtual tU32 calcCrc32 ( tU8 data[], tU16 length );
//   //! calculate CRC32 and compare with the given crc value
//   virtual bool calcAndCompareCrc32 ( tU8 data[], tU16 length, tU32 crc );

//   //! calculate CRC16
//   virtual tU16 calcCrc16 ( tU8 data[], tU16 length );
//   //! calculate CRC16 and compare with the given crc value
//   virtual bool calcAndCompareCrc16 ( tU8 data[], tU16 length, tU16 crc );

   //! calculate CRC (CCITT)
   virtual tU16 calcCrCCITT ( const tU8 data[], tU16 length, dia_eCRCFormat fmt=DIA_EN_CRC_FORMAT_BIG_ENDIAN );
   //! calculate CRC (CCITT) and compare with the given crc value
   virtual bool calcAndCompareCrcCCITT ( const tU8 data[], tU16 length, tU16 crc, dia_eCRCFormat fmt=DIA_EN_CRC_FORMAT_BIG_ENDIAN );

protected:
   //! default constructor
   dia_CRCCalculator ( void );
};

dia_CRCCalculator* getInstanceOfCRCCalculator ( void );
void releaseInstanceOfCRCCalculator ( void );

#endif /* __INCLUDED_DIA_CRC_CALCULATOR__ */
