/*
 * dia_CRCCalculator.cpp
 *
 *  Created on: 10.03.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_CRC_CALCULATOR__
#include "common/framework/utils/dia_CRCCalculator.h"
#endif

#include <boost/crc.hpp>      // for boost::crc_basic, boost::crc_optimal

//#include <boost/cstdint.hpp>  // for boost::uint16_t
//#include <algorithm>  // for std::for_each
//#include <cassert>    // for assert
//#include <cstddef>    // for std::size_t
//#include <iostream>   // for std::cout
//#include <ostream>    // for std::endl


//    // Main function
//    int
//    main ()
//    {
//        // This is "123456789" in ASCII
//        unsigned char const  data[] = { 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
//         0x38, 0x39 };
//        std::size_t const    data_len = sizeof( data ) / sizeof( data[0] );
//
//        // The expected CRC for the given data
//        boost::uint16_t const  expected = 0x29B1;
//
//        // Simulate CRC-CCITT
//        boost::crc_basic<16>  crc_ccitt1( 0x1021, 0xFFFF, 0, false, false );
//        crc_ccitt1.process_bytes( data, data_len );
//        assert( crc_ccitt1.checksum() == expected );
//
//        // Repeat with the optimal version (assuming a 16-bit type exists)
//        boost::crc_optimal<16, 0x1021, 0xFFFF, 0, false, false>  crc_ccitt2;
//        crc_ccitt2 = std::for_each( data, data + data_len, crc_ccitt2 );
//        assert( crc_ccitt2() == expected );
//
//        std::cout << "All tests passed." << std::endl;
//        return 0;
//    }


DIA_IMPL_SINGLETON(dia_CRCCalculator)

#ifndef __DIA_UNIT_TESTING__

dia_CRCCalculator*
getInstanceOfCRCCalculator ( void )
{
   return dia_CRCCalculator::getInstance();
}

void
releaseInstanceOfCRCCalculator ( void )
{
   return dia_CRCCalculator::deleteInstance();
}

#endif

//-----------------------------------------------------------------------------

dia_CRCCalculator::dia_CRCCalculator ( void )
{}

//-----------------------------------------------------------------------------

dia_CRCCalculator::~dia_CRCCalculator ( void )
{}

//-----------------------------------------------------------------------------

tU16
dia_CRCCalculator::calcCrCCITT ( const tU8 data[], tU16 length, dia_eCRCFormat fmt )
{
//#ifndef __DIA_UNIT_TESTING__
   // boost calculates the CRC in big endian format
   boost::crc_ccitt_type crc_ccitt;
   crc_ccitt.process_bytes(data,length);

   tU16 crc = crc_ccitt.checksum();
   tU16 crcFinal = ( fmt == DIA_EN_CRC_FORMAT_LITTLE_ENDIAN ) ? ((tU16)(((crc & 0x00FF) << 8) | ((crc & 0xFF00) >> 8))) : crc;
   DIA_TR_INF("CRC (CALCULATED) = 0x%04x", crc);
   DIA_TR_INF("CRC (FINAL)      = 0x%04x", crcFinal);

   return crcFinal;
//#else
//   return 0xFFFF;
//#endif
}

//-----------------------------------------------------------------------------

bool
dia_CRCCalculator::calcAndCompareCrcCCITT ( const tU8 data[], tU16 length, tU16 crc, dia_eCRCFormat fmt )
{
//#ifndef __DIA_UNIT_TESTING__
   tU16 crcCalc = calcCrCCITT(data,length,fmt);
   DIA_TR_INF("CRC (TO BE VERIFIED) = 0x%04x", crc);

   return ( crcCalc == crc ) ? true : false;
//#else
//   return false;
//#endif
}

//
//typedef crc_optimal<16, 0x8005, 0, 0, true, true>         crc_16_type;
//typedef crc_optimal<16, 0x1021, 0xFFFF, 0, false, false>  crc_ccitt_type;
//typedef crc_optimal<16, 0x8408, 0, 0, true, true>         crc_xmodem_type;
//
//typedef crc_optimal<32, 0x04C11DB7, 0xFFFFFFFF, 0xFFFFFFFF, true, true>
//  crc_32_type;
//
//}
