/**
 * \file      dia_UpdatePlugin.h
 *
 * \brief     {process the file line by line}
 *
 * \details   {process the file line by line}
 *
 * \author    bhs1hi
 * \date      Jan 25, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_LINE_PARSER__
#include "common/framework/update/dia_LineParser.h"
#endif

#ifndef __INCLUDED_DIA_FILE__
#include "common/framework/application/dia_File.h"
#endif

#ifndef __INCLUDED_DIA_UPADTE_PLUGIN__
#define __INCLUDED_DIA_UPADTE_PLUGIN__

class dia_UpdatePlugin
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_UpdatePlugin);

public:
   //! class constructor
   dia_UpdatePlugin ( void );
   //! class destructor
   virtual ~dia_UpdatePlugin ( void );

   //! parse the given file line by line and pass to the line parser to extract the contents like - key, length and data bytes
   virtual tDiaResult processUpdate ( void ) = 0;
};

#endif /* __INCLUDED_DIA_UPADTE_PLUGIN__ */
