/**
 * \file      dia_UpdateManager.h
 *
 * \brief     {VW Config update}
 *
 * \details   {VW Config update : KDS}
 *
 * \author    bhs1hi
 * \date      Jan 29, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_UPADTE_PLUGIN__
#include "common/framework/update/dia_UpdatePlugin.h"
#endif

#ifndef __INCLUDED_DIA_UPDATE_MANAGER__
#define __INCLUDED_DIA_UPDATE_MANAGER__

class dia_UpdatePlugin;

class dia_UpdateManager
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_UpdateManager);

public:
   //! class constructor
   dia_UpdateManager ( void );
   //! class destructor
   virtual ~dia_UpdateManager ( void );

   virtual tDiaResult addUpdatePlugin ( dia_UpdatePlugin* plugin );

   virtual tDiaResult runUpdate ( void );
      //{
      //bstl::list<dia_UpdatePlugin*>::iterator iter = mPluginRep.begin();
      //for ( ; iter != mluginRep.end(); iter++ )
      //   {
      //      if ( *iter ) (*iter)->processUpdate();
      //   }
      //}

protected:
   //! list of update plugins managed by the update manager
   std::list<dia_UpdatePlugin*> mPluginRep;
};

#endif /* __INCLUDED_DIA_UPDATE_MANAGER__ */
