/**
 * \file      dia_UpdateManager.cpp
 *
 * \brief     {VW Config update manager}
 *
 * \details   {VW Config update manager : KDS}
 *
 * \author    bhs1hi
 * \date      Jan 29, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_UPDATE_MANAGER__
#include "dia_UpdateManager.h"
#endif

DIA_IMPL_SINGLETON(dia_UpdateManager)

//#ifndef __DIA_UNIT_TESTING__

dia_UpdateManager*
getInstanceOfUpdateManager ( void )
{
   return dia_UpdateManager::getInstance();
}

void
releaseInstanceOfUpdateManager ( void )
{
   dia_UpdateManager::deleteInstance();
}

//#endif

//-----------------------------------------------------------------------------

dia_UpdateManager::dia_UpdateManager ( void )
{
   dia_tclFnctTrace trc("dia_UpdateManager::dia_UpdateManager");
}

//-----------------------------------------------------------------------------

dia_UpdateManager::~dia_UpdateManager ( void )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace trc("dia_UpdateManager::~dia_UpdateManager");
#endif

   _BP_TRY_BEGIN
   {
      mPluginRep.clear();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_UpdateManager::~dia_UpdateManager !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}
//-----------------------------------------------------------------------------

tDiaResult
dia_UpdateManager::addUpdatePlugin ( dia_UpdatePlugin* plugin )
{
   dia_tclFnctTrace oTrace("dia_UpdateManager::addUpdatePlugin()");

   if ( !plugin ) return DIA_E_INVALID_POINTER;

   DIA_TR_INF("dia_UpdateManager::addUpdatePlugin - 1");

   tDiaResult retCode = DIA_FAILED;

   tBool found = FALSE;
   std::list<dia_UpdatePlugin*>::iterator iter = mPluginRep.begin();
   for ( ; iter != mPluginRep.end(); iter++ )
   {
      DIA_TR_INF("dia_UpdateManager::addUpdatePlugin - 2");
      if ( (*iter) == plugin )
      {
         DIA_TR_INF("dia_UpdateManager::addUpdatePlugin - 3");
         found = TRUE;
         break;
      }
   }

   if ( found == FALSE )
   {
      DIA_TR_INF("dia_UpdateManager::addUpdatePlugin - 4");
      mPluginRep.push_back(plugin);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}
//-----------------------------------------------------------------------------

tDiaResult dia_UpdateManager::runUpdate ( void )
{
   dia_tclFnctTrace trc("dia_UpdateManager::runUpdate");

   tDiaResult retCode = DIA_FAILED;

   std::list<dia_UpdatePlugin*>::iterator iter = mPluginRep.begin();
   for ( ; iter != mPluginRep.end(); iter++ )
   {
      DIA_TR_INF("dia_UpdateManager::runUpdate - 1");
      if ( *iter ) (*iter)->processUpdate();
      retCode = DIA_SUCCESS;
   }
   return retCode;
}
