/**
 * \file      dia_SimpleUpdatePlugin.h
 *
 * \brief     {process the file line by line}
 *
 * \details   {process the file line by line}
 *
 * \author    bhs1hi
 * \date      Jan 25, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_SIMPLE_UPDATE_PLUGIN__
#define __INCLUDED_DIA_SIMPLE_UPDATE_PLUGIN__

#ifndef __INCLUDED_DIA_UPADTE_PLUGIN__
#include "dia_UpdatePlugin.h"
#endif


class dia_LineParser;

// ("/var/opt/bosch/dynamic/diagnosis/configupdate/") + ("7503200015_HW070.kds")
#define FILENAME_LENGTH        (47 + 20) // Pathlength[47] + filename length[20]

#define DIAG_DNL_PATH    "/var/opt/bosch/dynamic/diagnosis/configupdate/" // file path - length 47

//#define DIAG_FILE_FORMAT    ".kds"//length 4

class dia_SimpleUpdatePlugin : public dia_UpdatePlugin
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SimpleUpdatePlugin);

public:
   //! class constructor
   dia_SimpleUpdatePlugin ( void );
   //! class constructor
   dia_SimpleUpdatePlugin ( dia_LineParser* pLineParser );
   //! class destructor
   virtual ~dia_SimpleUpdatePlugin ( void );

   //! parse the given file line by line and pass to the line parser to extract the contents like - key, length and data bytes
   //virtual tDiaResult processUpdate ( const dia_File& file, const dia_LineParser& lineParser );
   virtual tDiaResult processUpdate ( void );


protected:

   tDiaResult setDiagFileName(void);

 	tChar diag_filename[FILENAME_LENGTH];

   dia_LineParser* mpParser;

   //! flag (indicates that the hardware index exists)
   bool mIsHWIndexExists;

};

#endif /* __INCLUDED_DIA_SIMPLE_UPDATE_PLUGIN__ */
