/**
 * \file      dia_SimpleDataSetUpdatePlugin.h
 *
 * \brief     {process the file line by line}
 *
 * \details   {process the file line by line}
 *
 * \author    nbs3kor
 * \date      Nov 10, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */
#ifndef __INCLUDED_DIA_SIMPLE_DATASET_UPDATE_PLUGIN__
#define __INCLUDED_DIA_SIMPLE_DATASET_UPDATE_PLUGIN__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_UPADTE_PLUGIN__
#include "dia_UpdatePlugin.h"
#endif


class dia_LineParser;

// ("/var/opt/bosch/dynamic/diagnosis/configupdate/") + ("7503200015_HW070.ds")
#define DATASET_FILENAME_LENGTH        (47 + 19) // Pathlength[47] + filename length[19]

#define DIAG_DATASET_DNL_PATH    "/var/opt/bosch/dynamic/diagnosis/configupdate/" // file path - length 47

//#define DIAG_FILE_FORMAT    ".ds "//length 3

class dia_SimpleDataSetUpdatePlugin : public dia_UpdatePlugin
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SimpleDataSetUpdatePlugin);

public:
   //! class constructor
   dia_SimpleDataSetUpdatePlugin ( void );
   //! class constructor
   dia_SimpleDataSetUpdatePlugin ( dia_LineParser* pLineParser );
   //! class destructor
   virtual ~dia_SimpleDataSetUpdatePlugin ( void );

   //! parse the given file line by line and pass to the line parser to extract the contents like - Logical adress, length and data bytes
   //virtual tDiaResult processUpdate ( const dia_File& file, const dia_LineParser& lineParser );
   virtual tDiaResult processUpdate ( void );


protected:

   tDiaResult setDiagDataSetFileName(void);

 	tChar diag_DataSet_filename[DATASET_FILENAME_LENGTH];

   dia_LineParser* mpParser;

   //! flag (indicates that the hardware index exists)
   bool mIsHWIndexExists;

};

#endif /* __INCLUDED_DIA_SIMPLE_DATASET_UPDATE_PLUGIN__ */
