/*
 * udd_IDriver.h
 *
 *  Created on: 04.04.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_UDD_INTERFACE_DRIVER__
#define __INCLUDED_DIA_UDD_INTERFACE_DRIVER__

#ifndef __INCLUDED_DIA_UDD__
#include "udd.h"
#endif

//namespace udd
//{

class udd_CommData;
class udd_CommParam;
class udd_CommParams;

class udd_IDriver
{
public:
    //! connect to the driver
    virtual tDiaResult connect ( udd_UID uid ) = 0;
    //! disconnect from the driver
    virtual tDiaResult disconnect ( udd_UID uid ) = 0;

    //! lock the driver
    virtual tDiaResult lock ( udd_UID uid ) = 0;
    //! unlock the driver
    virtual tDiaResult unlock ( udd_UID uid ) = 0;

    //! set communication parameters of the associated driver
    virtual tDiaResult setCommParams ( udd_UID uid, const udd_CommParams& params ) = 0;
    //! get a certain communication parameter of the associated driver
    virtual tDiaResult getCommParams ( udd_UID uid, udd_CommParams& params ) = 0;
    //! set communication parameters of the associated driver
    virtual tDiaResult setCommParam ( udd_UID uid, const udd_CommParam& param ) = 0;
    //! get a certain communication parameter of the associated driver
    virtual tDiaResult getCommParam ( udd_UID uid, tU32 pid, udd_CommParam& param ) = 0;

    //! synchronous send of a diagnostic message
    virtual tDiaResult send ( udd_UID uid, const udd_CommData& data, udd_CommData& response ) = 0;
    //! asynchronous send of a diagnostic message
    virtual tDiaResult sendAsync ( udd_UID uid, const udd_CommData& data ) = 0;
    //! asynchronous send of a diagnostic message
    virtual tDiaResult sendAsync ( udd_UID uid, const tU8 data[], tU16 length ) = 0;

protected:
    //! class destructor
    virtual ~udd_IDriver ( void ) {}
};

//-----------------------------------------------------------------------------

class udd_IDriverImpl
    : public udd_IDriver
{
public:
    //! connect to the driver
    virtual tDiaResult connect ( udd_UID /*uid*/ ) { return DIA_E_NOT_IMPLEMENTED; }
    //! disconnect from the driver
    virtual tDiaResult disconnect ( udd_UID /*uid*/ ) { return DIA_E_NOT_IMPLEMENTED; }

    //! lock the driver
    virtual tDiaResult lock ( udd_UID /*uid*/ ) { return DIA_E_NOT_IMPLEMENTED; }
    //! unlock the driver
    virtual tDiaResult unlock ( udd_UID /*uid*/ ) { return DIA_E_NOT_IMPLEMENTED; }

    //! set communication parameters of the associated driver
    virtual tDiaResult setCommParams ( udd_UID /*uid*/, const udd_CommParams& /*params*/ ) { return DIA_E_NOT_IMPLEMENTED; }
    //! get a certain communication parameter of the associated driver
    virtual tDiaResult getCommParams ( udd_UID /*uid*/, udd_CommParams& /*params*/ ) { return DIA_E_NOT_IMPLEMENTED; }
    //! set communication parameters of the associated driver
    virtual tDiaResult setCommParam ( udd_UID /*uid*/, const udd_CommParam& /*param*/ ) { return DIA_E_NOT_IMPLEMENTED; }
    //! get a certain communication parameter of the associated driver
    virtual tDiaResult getCommParam ( udd_UID /*uid*/, tU32 /*pid*/, udd_CommParam& /*param*/ ) { return DIA_E_NOT_IMPLEMENTED; }

    //! synchronous send of a diagnostic message
    virtual tDiaResult send ( udd_UID /*uid*/, const udd_CommData& /*data*/, udd_CommData& /*response*/ ) { return DIA_E_NOT_IMPLEMENTED; }
    //! asynchronous send of a diagnostic message
    virtual tDiaResult sendAsync ( udd_UID /*uid*/, const udd_CommData& /*data*/ ) { return DIA_E_NOT_IMPLEMENTED; }
    //! asynchronous send of a diagnostic message
    virtual tDiaResult sendAsync ( udd_UID /*uid*/, const tU8 /*data*/[], tU16 /*length*/ ) { return DIA_E_NOT_IMPLEMENTED; }

protected:
    //! class destructor
    virtual ~udd_IDriverImpl ( void ) {}
};

//} // end of namespace

#endif /* __INCLUDED_DIA_UDD_INTERFACE_DRIVER__ */
