/*
 * udd_DriverFacade.cpp
 *
 *  Created on: 04.04.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_UDD_COMMUNICATION_CHANNEL__
#include "udd_CommChannel.h"
#endif

#ifndef __INCLUDED_DIA_UDD_DRIVER_FACADE__
#include "udd_DriverFacade.h"
#endif

//namespace udd
//{

DIA_IMPL_SINGLETON(udd_DriverFacade)

#ifndef __DIA_UNIT_TESTING__

udd_DriverFacade*
getInstanceOfFacadeUDD ( void )
{
   return udd_DriverFacade::getInstance();
}

void
releaseInstanceOfFacadeUDD ( void )
{
   udd_DriverFacade::deleteInstance();
}

#endif

//-----------------------------------------------------------------------------

udd_DriverFacade::udd_DriverFacade ( void )
{
}

//-----------------------------------------------------------------------------

udd_DriverFacade::~udd_DriverFacade ( void )
{
}

//-----------------------------------------------------------------------------

tDiaResult
udd_DriverFacade::assign ( udd_CommChannel& channel )
{
    tDiaResult retCode = DIA_FAILED;

    if ( channel.getUID() != UDD_CHANNEL_UID_UNKNOWN )
    {
        mChannelRep[channel.getUID()] = &channel;
        retCode  = DIA_SUCCESS;
    }
    else
    {
       //try UID list
       const std::list<udd_UID> uidList = channel.getUIDs();
       std::list<udd_UID>::const_iterator iter = uidList.begin();
       for (; iter != uidList.end(); iter++)
       {
          mChannelRep[*iter] = &channel;
          retCode  = DIA_SUCCESS;
       }
    }

    return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
udd_DriverFacade::queryCommChannel ( udd_UID uid, udd_CommChannel** pChannel )
{
    tDiaResult retCode = DIA_FAILED;

    if ( pChannel && (uid != UDD_CHANNEL_UID_UNKNOWN) )
    {
        std::map<udd_UID,udd_CommChannel*>::iterator iter = mChannelRep.find(uid);
        if ( iter != mChannelRep.end() )
        {
            *pChannel = mChannelRep[uid];
            retCode  = DIA_SUCCESS;
        }
    }

    return retCode;
}

//} // end of namespace

