/*
 * udd_CommData.h
 *
 *  Created on: 04.04.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_UDD_COMMUNICATION_DATA__
#define __INCLUDED_DIA_UDD_COMMUNICATION_DATA__

/*
 *  Byte      0: physical channel type (CAN, USB, TCP/IP, RS232, ...) --> 1 Byte
 *  Byte      1: protocol (UDS, MCNET, ...) --> 1 Byte
 *  Byte   2..5: control flags (e.g. internal, ...) --> 2 Bytes
 *  Byte   6..7: reference count --> 2 Bytes
 *  Byte  8..11: async. continuation token -->
 *  Byte       : opcode (CONTROL (internal), REQUEST (from ext. tester), STATUS, ERROR, RESPONSE, CONFIRMATION
 *  Byte       : length of additional channel information (e.g. physical or functional addressed,...)
 *  Byte       : data
 *
 */

#define UDD_C_U16_MAX_RAWDATA_LEN       ((tU16) 4096) // 4KBytes

//namespace udd
//{

// Byte        : message code (2 byte
struct udd_CommDataRaw
{
    //! constructor
   udd_CommDataRaw ( tU8 rawData[], tU16 len );

    //! reference counter
    tU16 mRefCount;
    //! raw data length
    tU16 mRawDataLen;
    //! raw data
    tU8  mDataRaw[UDD_C_U16_MAX_RAWDATA_LEN];
};

class udd_CommData
{
public:
    //! copy constructor
   udd_CommData ( const udd_CommData& obj );
    //! constructor used to create an object from an existing CommDataRaw object
   udd_CommData ( udd_CommDataRaw& rawData );
    //! constructor used to create an object from a raw binary data stream
   udd_CommData ( tU8 rawData[], tU16 len );

    //! assigment operator
   udd_CommData& operator = ( const udd_CommData& obj );

   virtual ~udd_CommData();

protected:
    //! deprecated default constructor
   udd_CommData ( tVoid );

protected:
    //! link to the raw data
   udd_CommDataRaw* mpRawData;
};


#endif /* __INCLUDED_DIA_UDD_COMMUNICATION_DATA__ */
