/*
 * udd_CommChannel.h
 *
 *  Created on: 31.03.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_UDD_COMMUNICATION_CHANNEL__
#define __INCLUDED_DIA_UDD_COMMUNICATION_CHANNEL__

#ifndef __INCLUDED_DIA_UDD__
#include "udd.h"
#endif

#ifndef __INCLUDED_DIA_UDD_INTERFACE_DRIVER__
#include "udd_IDriver.h"
#endif

//namespace udd
//{

class udd_CommData;
class udd_CommParam;
class udd_CommParams;
class udd_CommChannelListener;

class udd_CommChannel
    : public udd_IDriverImpl
{
public:
   //! return name of object
   tCString getName ( void ) const { return mName; }
   //! return the unique channel identifier
   const udd_UID& getUID ( void ) const { return mUID; }
   //! return the unique channel identifier
   const std::list<udd_UID>& getUIDs ( void ) const { return mUIDRep; }

//    //! return the type of communication channel
//    eCommChannelType getType ( void ) const { return mType; }
//    //! return the protocol for communicating via this channel
//    eCommProtocol getProtocol ( void ) const { return mProtocol; }

   //!
//   virtual tDiaResult addServiceProvider ( udd_UID channelUID, udd_CommChannelListener* pServiceProvider );
   virtual tDiaResult addController ( udd_UID channelUID, udd_CommChannelListener* pController );
   virtual udd_CommChannelListener* getController ( udd_UID channelUID );

protected:
   //! deprecated default constructor without implementation
   udd_CommChannel ( void );
   //! class constructor
   udd_CommChannel ( tCString name, udd_UID uid /*eCommChannelType cid, eCommProtocol pid*/ );
   //! class constructor
   udd_CommChannel ( tCString name, std::list<udd_UID>& uidList /*eCommChannelType cid, eCommProtocol pid*/ );
   //! class destructor
   virtual ~udd_CommChannel ( void );

protected:
//    //! class variable used for generating unique channel IDs
//    static tU32 mSerial;

   //! name of object
   tCString mName;
   //! unique channel identifier
   udd_UID mUID;
   //! unique channel identifier
   std::list<udd_UID> mUIDRep;
//   //! repository of registered listeners
//   std::map<udd_UID,udd_CommChannelListener*> mServiceProviderRep;
//   //! repository of registered listeners
   std::map<udd_UID,udd_CommChannelListener*> mControllerRep;

//    //! channel type
//    eCommChannelType mType;
//    //! protocol
//    eCommProtocol mProtocol;
//    udd_ChannelInfo* mChannelInfo;
};

//} // end of namespace

#endif /* __INCLUDED_DIA_UDD_COMMUNICATION_CHANNEL__ */
