/*
 * udd_CommChannel.cpp
 *
 *  Created on: 31.03.2011
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_UDD_COMMUNICATION_CHANNEL__
#include "udd_CommChannel.h"
#endif

//namespace udd
//{

//tU32
//CommChannel::mSerial = 0;

////-----------------------------------------------------------------------------
//
//CommChannel::CommChannel ( eCommChannelType cid, eCommProtocol pid )
//    : mType(cid),
//      mProtocol(pid)
//{
//    mUID = ++mSerial;
//}

//-----------------------------------------------------------------------------

udd_CommChannel::udd_CommChannel ( tCString name, udd_UID uid )
    : mName(name),
      mUID(uid)
{}

//-----------------------------------------------------------------------------

udd_CommChannel::udd_CommChannel ( tCString name, std::list<udd_UID>& uidList /*eCommChannelType cid, eCommProtocol pid*/ )
   : mName(name),
     mUID(UDD_CHANNEL_UID_UNKNOWN),
     mUIDRep(uidList)
{}

//-----------------------------------------------------------------------------

udd_CommChannel::~udd_CommChannel ( void )
{
   mName = 0;
}

//-----------------------------------------------------------------------------

tDiaResult
udd_CommChannel::addController ( udd_UID channelUID, udd_CommChannelListener* pController )
{
   tDiaResult retCode = DIA_FAILED;

   std::map<udd_UID,udd_CommChannelListener*>::iterator iter = mControllerRep.find(channelUID);
   if (iter == mControllerRep.end())
   {
      mControllerRep[channelUID] = pController;
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_ERR("!!! udd_CommChannel::addController: Channel UID=0x%x has already a Controller", iter->first);
   }

   return retCode;
}

//-----------------------------------------------------------------------------

udd_CommChannelListener* udd_CommChannel::getController ( udd_UID channelUID )
{
   udd_CommChannelListener* pListener = 0;
   std::map<udd_UID,udd_CommChannelListener*>::iterator iter = mControllerRep.find(channelUID);
   if (iter != mControllerRep.end())
   {
      pListener = iter->second;
   }

   return pListener;
}


//}
