#include "dia_DoIP.h"


#include <sstream>



/*
  not in namespace dia:
  implement intentionally missing static method required by DoIP-lib
 */

namespace dia {

DoIP_Channel *dia_DoIP_Factory::createChannel(DoIP_Connection* poConn, DoIP_ChannelType type, tU8 busNumber, tU16 testerSA, tU16 targetSA, tU32 baseaddr, tU8 addrext) {
   dia::dia_DoIPChannelCreationParams chnCreationParams;
   chnCreationParams.poConn=poConn;
   chnCreationParams.type=type;
   chnCreationParams.busNumber=busNumber;
   chnCreationParams.testerSA=testerSA;
   chnCreationParams.targetSA=targetSA;
   chnCreationParams.baseaddr=baseaddr;
   chnCreationParams.addrext=addrext;
   
   return dia::dia_DoIP::getInstance()->createDoIPChannel(chnCreationParams);
}


void dia_DoIP::removeServer(dia_DoIPServer* /*server*/) {
   // todo: is this really a use-case???
}

DoIP_RoutingActivationTarget const *dia_DoIP::getTarget(uint16_t targetSA) {
   for (uint32_t i=0; i<_cfg->numTargets; ++i) {
      if (_cfg->targets[i].targetSA== targetSA) {
         return &_cfg->targets[i].routingActivationTarget;
      }
   }
   return 0;
}

dia_DoIP::dia_DoIP() :
   _cfg(nullptr),
   _localCfg(nullptr),
   _ethBus(nullptr),
   _poDoIPStack(nullptr),
   _server(nullptr),
   _doipFactory(nullptr)
{
};


bool dia_DoIP::configure(dia_DoIPCfg const &cfg)
{
   _cfg=&cfg;
   _localCfg=_cfg->localCfg;
   char const *device=_localCfg->ethInterfaceName.c_str();
   char const *tst="ethernet";
   printf("%s", tst);
   _doipFactory=new dia_DoIP_Factory();
   _ethBus=new dia_EthernetDoIPBus(_localCfg->busNumber, device);
   _poDoIPStack = _ethBus->poSetDoIPConfig(_localCfg->portNumber,
                                           _localCfg->localTargetSA,
                                           _localCfg->eid.length() ? _localCfg->eid.c_str() : 0,
                                           _localCfg->gid.length() ? _localCfg->gid.c_str() : 0,
                                           _doipFactory);
   if (_localCfg->vin.length()) {
      // todo: why unsigned char for VIN, it is supposed to be a string
	  char const *vinStr=_localCfg->vin.c_str();
	  printf("%s", vinStr);
	  tU8 vinLen=(tU8)_localCfg->vin.length();
	  tst="bla";

      _poDoIPStack->vSetVIN((tU8 const *)vinStr, vinLen);
   }
   printf("%s", tst);
   // create routes without targets
   for (uint32_t i=0; i<_cfg->numRoutes; ++i) {
      uint16_t routeNumber=_cfg->routes[i].routeNumber;
      bool bAuthRequ=_cfg->routes[i].bAuthRequ;
      DoIP_RoutingActivationCfg routeCfg;
      routeCfg.bAuthRequ=bAuthRequ;
      _routes[routeNumber]=routeCfg;
   }
   
   
   // add targets to routes
   for (uint32_t i=0; i<_cfg->numRouteTargets; ++i) {
      uint16_t routeNumber=_cfg->routeTargets[i].routeNumber;
      uint16_t targetSA=_cfg->routeTargets[i].targetSA;
      DoIP_RoutingActivationCfg *route=getRoute(routeNumber);
      if (!route) {
         continue;
      }
      DoIP_RoutingActivationTarget const *target=getTarget(targetSA);
      if (!target) {
         continue;
      }
      route->targetCfg.push_back(*target);
   }
   
   
   // create testers
   for (uint32_t i=0; i<_cfg->numTesters; ++i) {
      uint16_t testerSA=_cfg->testers[i].testerSA;
      uint16_t numByteDiagAckNack=_cfg->testers[i].numByteDiagAckNack;
      _testers[testerSA]=_poDoIPStack->poAddTesterCfg(testerSA, numByteDiagAckNack);;
   }
   
   // add routes to testers
   for (uint32_t i=0; i<_cfg->numTesterRoutes; ++i) {
      uint16_t testerSA=_cfg->testerRoutes[i].testerSA;
      uint8_t routeNumber=_cfg->testerRoutes[i].routeNumber;
      DoIP_TesterCfg *tester=getTester(testerSA);
      DoIP_RoutingActivationCfg *route=getRoute(routeNumber);
      if (tester && route) {
         tester->oRouteActCfg[routeNumber]=*route;
      }
   }
   
   _server=new dia_DoIPServer(this, _ethBus, _localCfg);
   
   for (uint32_t i=0; i<_cfg->numDoIPChannelCreators;++i) {
      _doIPChannelFactory.registerCreator(_cfg->doIPChannelCreators[i]);
   }
   return true;
}


bool dia_DoIP::startCommunication() {
   return _ethBus->bStart();
}

DoIP_RoutingActivationCfg *dia_DoIP::getRoute(uint16_t routeNumber) {
   std::map<uint16_t, DoIP_RoutingActivationCfg>::iterator iter=_routes.find(routeNumber);
   if (iter == _routes.end()) {
      return 0;
   }
   return &(iter->second);
}

DoIP_TesterCfg *dia_DoIP::getTester(uint16_t testerSA) {
   std::map<uint16_t, DoIP_TesterCfg *>::iterator iter=_testers.find(testerSA);
   if (iter == _testers.end()) {
      return 0;
   }
   return iter->second;
}

DoIP_Channel *dia_DoIP::createDoIPChannel(dia_DoIPChannelCreationParams const &chnCreationParams) {
   DoIP_Channel *channel=_doIPChannelFactory.createChannel(chnCreationParams);
   return channel;
}


dia_EthernetDoIPBus::dia_EthernetDoIPBus(tU8 u8Number, char const *device)
   : tclEthernetBus(u8Number, device),
     dia_ActiveObject("DIA_DOIP_THREAD", DIA_PROP_TCP_THREAD_PRIO, DIA_PROP_TCP_THREAD_STACKSIZE), // todo:define config-items, currently stolen from TCP
     _lock(getLockName(u8Number).c_str()),
     _started(false)
{}

dia_EthernetDoIPBus::dia_EthernetDoIPBus(tU8 u8Number, sockaddr_in rAddr)
   : tclEthernetBus(u8Number, rAddr),
     dia_ActiveObject("DIA_DOIP_THREAD", DIA_PROP_TCP_THREAD_PRIO, DIA_PROP_TCP_THREAD_STACKSIZE), // todo:define config-items, currently stolen from TCP
     _lock(getLockName(u8Number).c_str()),
     _started(false)
{}


bool dia_EthernetDoIPBus::bStart()
{
   if (!tclEthernetBus::bStart()) {
      return false;
   }
   if ( DIA_SUCCESS != startThread())
   {
      DIA_TR_INF("!!! dia_DoIP::tclEthernetBus => ERROR: start thread failed.");
      return false;;
   }
   return true;
}

bool dia_EthernetDoIPBus::bStop()
{
   _started=false;
   return (terminateThread() == DIA_SUCCESS);
}



bool dia_EthernetDoIPBus::bEnterCriticalSection() 
{
   return  _lock.lock()==DIA_SUCCESS ? true : false;
}

bool dia_EthernetDoIPBus::bLeaveCriticalSection()
{
   return  _lock.unlock()==DIA_SUCCESS ? true : false;
}

std::string dia_EthernetDoIPBus::getLockName(tU8 u8Number) {
   std::ostringstream oss;
   std::string lockName;
   oss << "ETH_DOIP_" << u8Number;
   lockName=oss.str();
   return lockName;
}

void dia_EthernetDoIPBus::vThreadEntrypointObject ( void )
{
   _started=true;
   dia_tclFnctTrace oTrace("dia_DoIP::tclEthernetBus::vThreadEntrypointObject");
   while(_started)
   {
      usleep(tclEthernetBus::cu32CommonTimerStep * 1000); // DiagOmitSleepWarning: Required for thread synchronization
      vCommonTimerTick();
   }
   tclEthernetBus::bStop();
   
}


DIA_IMPL_SINGLETON(dia_DoIP);


dia_DoIPServer::dia_DoIPServer(dia_DoIP *diagDoIP, tclEthernetBus* poBus, dia_DoIPLocalCfg const *localCfg):
   DoIP_Server(poBus, localCfg->localTargetSA, localCfg->vin.c_str(), (tU8)localCfg->vin.length()),
      _diagDoIP(diagDoIP)
   {
   }

   dia_DoIPServer::~dia_DoIPServer()
   {
      _diagDoIP->removeServer(this);
   };


void dia_DoIPChannelFactory::registerCreator(dia_IDoIPChannelCreator *creator) {
      _creators.push_back(creator);
}


DoIP_Channel* dia_DoIPChannelFactory::createChannel(dia_DoIPChannelCreationParams const &chnCreationParams) {
   DoIP_Channel* chan = nullptr;
   // try to find a creator for the requested DoIP-channel
   for (std::list<dia_IDoIPChannelCreator *>::iterator iter=_creators.begin();
        iter!=_creators.end();
        ++iter) {
      dia_IDoIPChannelCreator *creator=*iter;
      if (creator->fits(chnCreationParams.type, chnCreationParams.testerSA, chnCreationParams.targetSA )) {
         chan=creator->createChannel(chnCreationParams);
         break;
      }
   }
   return chan;
}


}


