/*
 * dia_CommChannelTCP.h
 *
 *  Created on: 16.04.2015
 *      Author: gpu2kor
 */

#ifndef __INCLUDED_DIA_COMMCHANNEL_TCP__
#define __INCLUDED_DIA_COMMCHANNEL_TCP__

#ifndef __INCLUDE_DIA_ACTIVE_OBJECT__
#include <common/framework/application/dia_ActiveObject.h>
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_RUNLEVEL_LISTENER__
#include <common/interfaces/dia_IRunLevelListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__
#include <common/interfaces/dia_ISessionListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SECURITYLEVEL_LISTENER__
#include <common/interfaces/dia_ISecurityListener.h>
#endif

#ifndef __INCLUDED_DIA_UDD__
#include <common/framework/udd/udd.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGEHANDLER__
#include <common/framework/engine/dia_MessageHandler.h>
#endif

#ifdef USE_DGRAM_SERVICE
#include "dgram_service.h"
#endif



struct diag_doip_info{
   unsigned char prot_version;
   unsigned char inv_prot_version;
   unsigned char payload_type[2];
   unsigned int payload_len;
   unsigned char tester_logical_addr[2];
   unsigned char ecu_logical_addr[2];
};
class dia_CommChannelTCP
    : public dia_ActiveObject,
      public dia_IRunLevelListener,
      public dia_ISessionListenerImpl,
      public dia_ISecurityListenerImpl,
      public udd_CommChannel,
      public dia_MessageHandler
{
    DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_CommChannelTCP);
public:
    //! singleton access
    //static dia_CommChannelTCP* getInstance ( tVoid );

    //! connect to the driver
    virtual tDiaResult connect ( udd_UID uid );
    //! disconnect from the driver
    virtual tDiaResult disconnect ( udd_UID uid );

    //! asynchronous send of a diagnostic message
    virtual tDiaResult sendAsync ( udd_UID /*uid*/, const tU8 /*data*/[], tU16 /*length*/ ) { return DIA_E_NOT_IMPLEMENTED; }

    //! overloaded method from dia_IRunLevelListener
    virtual tVoid vOnRunLevelChanged ( dia_enRunlevel newLevel, dia_enRunlevel oldLevel );
    //! overloaded method from dia_ISessionListener
    virtual tVoid vOnSessionChanged ( tU8 newSession, tU8 oldSession );

    //! overloaded method from dia_IServiceListener
    virtual void vOnSecurityLevelChanged ( dia_SecurityLevel* pNewLevel, dia_SecurityLevel* pOldLevel );

protected:
    //! protected because we are using the singleton pattern
    dia_CommChannelTCP ( void );
    //! protected because we are using the singleton pattern
    virtual ~dia_CommChannelTCP ( void );

    //! thread function
    void vThreadEntrypointObject ( void );

    //! Copy data, create a message and send it to message processor
    void OnDiagRequest (const unsigned char* in_pTxBuffer, tU16 dataLength);

    static tVoid onDiagnosisResponse ( const tU8 au8MsgBuffer[], tU16 u16Length, tCookieType cookie );

    tU16 get_diag_data(const unsigned char* in_buffer,ssize_t numRecvBytes, unsigned char* res_buffer) const;

    tVoid sendDoIPAck(tVoid) const;

    tDiaResult OnTesterDisconnected ( void ) const;

    //tU16 getSecLevelMask (const dia_SecurityLevel* pSecLevel) const;
protected:

    //! tester present indication, true if tester is present
    static bool msTesterPresent;

    static int m_nSocketFd;

    static int client_socketFd;
#ifdef USE_DGRAM_SERVICE
    static sk_dgram *dgram;
#endif

    static unsigned char m_au8RecvBuffer[];
    static unsigned char m_au8SendBuffer[];
    static diag_doip_info frame_info;
};

dia_CommChannelTCP* getInstanceOfCommChannelTCP ( void );
void releaseInstanceOfCommChannelTCP ( void );

#endif /* __INCLUDED_DIA_COMMCHANNEL_TCP__ */

