/*!
 * \file       dia_CommChannelDoIP.h
 *
 * \brief      Communication channel used for DOIP communication
 *
 * \details    Communication channel used for Ethernet communication
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreUDD
 *
 * \copyright  (c) 2015-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_COMMCHANNEL_DOIP__
#define __INCLUDED_DIA_COMMCHANNEL_DOIP__


#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>


#ifndef __INCLUDED_DIA_DOIP__
#include "common/framework/udd/dia_DoIP.h"
#endif


#ifndef __INCLUDED_DIA_APPCONTROLLER__
#include "common/framework/application/dia_AppController.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include "common/framework/engine/dia_EngineManager.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

#ifndef __INCLUDED_DIA_SESSION_CONTROLLER__
#include "common/framework/application/dia_SessionController.h"
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include "common/framework/engine/dia_Session.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_SECURITY__
#include "common/framework/security/dia_common_security.h"
#endif
#ifndef __INCLUDED_DIA_UTILITIES__
#include <common/framework/utils/dia_utilities.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework//engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER_UDS__
#include "common/framework/protocols/uds/dia_MessageBufferUDS.h"
#endif

#ifndef __INCLUDED_DIA_DIAGSESSION_UDS__
#include "common/depricated/dia_tclDiagSessionUds.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include "common/interfaces/dia_ITimerListener.h"
#endif

#define DIA_NUM_ARR_ELEMS(arr) (sizeof(arr)/sizeof(arr[0]))
#define DEFAULT_MSGSZ                           4096
#define AF_BOSCH_INC_AUTOSAR                    PF_INET //41 /* AF_INC */
//#define PORT_OFFSET                             0xC700
#define DIA_UDD_PORT                            13400           //(0x05 | PORT_OFFSET)
#define PAYLOAD_LEN_OFFSET                      4   //prot_version = 1 byte,inv_prot_version = 1 byte, payload type = 2bytes
#define DOIP_ACK_FRAME_LENGTH                   12
#define PAYLOAD_TYPE_DIAG_DATA                   0x8001
#define PAYLOAD_TYPE_POS_ACK                    0x8002
//#define PAYLOAD_TYPE_NACK                       0x8003
#define DOIP_MSG_HEADER_LEN                       12

//using namespace std;
//using namespace udd;

#define DIA_DOIP_ROUTE_NUMBER_LOCAL 0x02
#define DIA_DOIP_BUS_NUMBER_ETH 0
#define DIA_DOIP_PORT 13400
#define DIA_DOIP_SA_LOCAL  0x0747 // 1863
#define DIA_DOIP_SA_TESTER 0x0767 // 1895
// todo: make config-item?
#if defined(GEN4ARM)
#define DIA_DOIP_ETH_NAME "eth1"
#else
#define DIA_DOIP_ETH_NAME "ethernet"
#endif
#define DIA_DOIP_EID "000000000000"
#define DIA_DOIP_GID "000000000000"
#define DIA_DOIP_VIN "00000000000000000"
#define DIA_DOIP_P2_TIME      50
#define DIA_DOIP_P2EXT_TIME   2000
#define DIA_DOIP_S3_TIME      5000


#include <string>
#include <fstream>
#include <streambuf>
#include <sstream>


#include "doipserver/DoIP_ServerCfg.h"
#include "doipcommon/DoIP_Types.h"
#include "doipserver/DoIP_Protocoll.h"
#include "doipserver/DoIP_Server.h"
#include "doipserver/DoIP_Channel.h"

#include "common/framework/udd/udd_CommChannel.h"
#include "common/framework/engine/dia_MessageHandler.h"

namespace dia {

class dia_CommChannelDoIP;
class IDiagnosisResponseListener;


class dia_DoipChannelCreator: public dia_IDoIPChannelCreator {
   virtual bool fits(DoIP_ChannelType type, tU16 /*testerSA*/, tU16 /*targetSA*/) {
      return type == DOIP_LOCAL;
   }
   virtual DoIP_Channel *createChannel(dia_DoIPChannelCreationParams const &chnCreationParams);
};




class dia_CommChannelDoIP :
      //   : public dia_ActiveObject,
     public dia_IRunLevelListener,
     public dia_ISessionListenerImpl,
     public dia_ISecurityListenerImpl,
     public udd_CommChannel,
     public dia_MessageHandler,
     public dia_IDoIPListener,
     public dia_ITimerListener
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_CommChannelDoIP);
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_CommChannelDoIP) ;
public:
   static dia_CommChannelDoIP *createInstance(udd_UID uid, tU16 P2, tU16 P2ext, tU16 S3);

private:
   dia_CommChannelDoIP(udd_UID uid, tU16 P2, tU16 P2ext, tU16 S3);


   virtual ~dia_CommChannelDoIP ( void );


public:
   void setSender(dia_IDoIPSender *sender) {
      _sender=sender;
   }

   //! connect to the driver
   virtual tDiaResult connect( udd_UID /* uid */ );
   //! disconnect from the driver
   virtual tDiaResult disconnect ( udd_UID /* uid */ );


   virtual tVoid vOnRunLevelChanged ( dia_enRunlevel newLevel, dia_enRunlevel oldLevel );

   //! overloaded method from dia_ISessionListener
   virtual tVoid vOnSessionChanged ( tU8 newSession, tU8 oldSession );

   //! overloaded method from dia_IServiceListener
   virtual void vOnSecurityLevelChanged ( dia_SecurityLevel* pNewLevel, dia_SecurityLevel* pOldLevel );


   void addDiagnosisResponseListener(IDiagnosisResponseListener *onDiagnosisResponseListener ) {
      DIA_TR_INF( "--- dia_CommChannelDoIP::addDiagnosisResponseListener(%p)",  onDiagnosisResponseListener);
      _onDiagnosisResponseListenerRep.remove(onDiagnosisResponseListener);
      _onDiagnosisResponseListenerRep.push_back(onDiagnosisResponseListener);
   }

   void removeDiagnosisResponseListener(IDiagnosisResponseListener *onDiagnosisResponseListener ) {
      DIA_TR_INF( "--- dia_CommChannelDoIP::removeDiagnosisResponseListener(%p)",  onDiagnosisResponseListener);
      _onDiagnosisResponseListenerRep.remove(onDiagnosisResponseListener);
   }


#if 0
   virtual tDiaResult addController ( udd_UID channelUID, udd_CommChannelListener* pController );
   virtual udd_CommChannelListener* getController ( udd_UID channelUID );
#endif


   /* dia_IDoIPListener: reception has started */
   virtual tU32 u32RxStartOfReception(tU32 u32Len);
   /* dia_IDoIPListener: data are received */
   virtual void vRxIndication(tU8 au8Data[], tU32 u32Len);


   /* dia_IDoIPListener: data have been sent */
   virtual void vTxConfirmation(tBool bOk);

   /* dia_IDoIPListener: data could not be received */
   virtual void vRxError(tU32 u32Error);
   /* dia_IDoIPListener: called from context for destructor of doip-channel */
   virtual void onDoipChnDestroy();
   /* dia_IDoIPListener END */




public:

   // send data to tester
   static tVoid onDiagnosisResponse ( const tU8 au8MsgBuffer[], tU16 u16Length, tCookieType cookie );

   bool isConnected() {
      return _sender != 0;
   }
   dia_Lock &getSyncObj() {
      return mSyncObj;
   }


protected:


   // receive data from tester
   //! Copy data, create a message and send it to message processor
   void OnDiagRequest (const unsigned char* in_pTxBuffer, tU16 dataLength);

   tVoid onDiagnosisResponse ( const tU8 au8MsgBuffer[], tU16 u16Length );


private:
   void setDefaultSession();
   dia_Lock mSyncObj;
   dia_IDoIPSender *_sender;
   udd_UID _uid;
   bool _connected;
   std::list<IDiagnosisResponseListener *> _onDiagnosisResponseListenerRep;

private:
   // section for TesterPresent and ResponsePending emulation
   const tU16 cu16S3Server;
   const tU16 cu16P2;
   const tU16 cu16P2ext;

   static const tU8  cu8SID_TesterPresent      = 0x3E;
   static const tU8  cu8SID_NegResp            = 0x7F;
   static const tU8  cu8NRC_ResponsePending    = 0x78;
   static const tU8  cu8SUB_SupprPosRespUDS    = 0x80;
   static const tU8  cu8SID_RespOffset         = 0x40;

   tU8  u8ActiveSID;

   dia_Timer oP2Timer;
   tU32 mP2TimerID;
   dia_Timer oS3Timer;
   tU32 mS3TimerID;

   //! overloaded method from class dia_ITimerListener
   virtual void vOnTimerElapsed ( dia_TimerID id );
   void vResponsePendingTimeout(void);
   void vTesterTimeout(void);

};
//tU16
//dia_CommChannelDoIP::getSecLevelMask (const dia_SecurityLevel* pSecLevel) const
//{
//   dia_tclFnctTrace oTrace("dia_CommChannelDoIP::getSecLevelMask");
//}




}

#endif

