#ifndef __INCLUDED_DIA_COMMCHANNEL_DOIP__
#include "dia_CommChannelDoIP.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGNOSIS_RESPONSE_LISTENER__
#include "common/interfaces/dia_IDiagnosisResponseListener.h"
#endif

namespace dia {

dia_CommChannelDoIP *dia_CommChannelDoIP::mpInstance=0;

DoIP_Channel *dia_DoipChannelCreator::createChannel(dia::dia_DoIPChannelCreationParams const &chnCreationParams) {
   dia::dia_DoIPChannel *doIPChannel=0;

   dia::dia_CommChannelDoIP *commChannel=0;
   do {
      // 1.) crate DoIP-channel according to DoIp-stack
      commChannel=dia_CommChannelDoIP::getInstance();
      {
         // we need a lock here, since commChannel is also accessed by doip-stack
         dia_LockScope mScopeLock(commChannel->getSyncObj());
         if (commChannel->isConnected()) {
            // comm-channel is already in use
            break;
         }
         doIPChannel=new dia::dia_DoIPChannel(chnCreationParams.poConn ,chnCreationParams.targetSA, commChannel);
         commChannel->setSender(doIPChannel);
      }
   } while(0);
   
   return doIPChannel;
}

dia_CommChannelDoIP::dia_CommChannelDoIP(udd_UID uid, tU16 P2, tU16 P2ext, tU16 S3):
   udd_CommChannel("dia_CommChannelDoIP",uid),
   mSyncObj("CommChannelDoIP_LK"),
   _sender(nullptr),
   _uid(0),
   _connected(false),
   cu16S3Server(S3),
   cu16P2(P2),
   cu16P2ext(P2ext),
   u8ActiveSID(0)
   {
      oP2Timer.s32Create();
      mP2TimerID = oP2Timer.getID();

      oS3Timer.s32Create();
      mS3TimerID = oS3Timer.getID();
   }

   dia_CommChannelDoIP::~dia_CommChannelDoIP() {
      _sender=nullptr;

      oP2Timer.removeTimerListener(this);
      oP2Timer.s32Delete();
      mP2TimerID = 0xFFFFFFFF;

      oS3Timer.removeTimerListener(this);
      oS3Timer.s32Delete();
      mS3TimerID = 0xFFFFFFFF;
   }

// static
   dia_CommChannelDoIP *dia_CommChannelDoIP::createInstance(udd_UID uid, tU16 P2, tU16 P2ext, tU16 S3) {
      if (!mpInstance) {
         mpInstance=new dia_CommChannelDoIP(uid, P2, P2ext, S3);
      }
      return mpInstance;
   }


   dia_CommChannelDoIP *dia_CommChannelDoIP::getInstance() {
      return mpInstance;
   }


   void dia_CommChannelDoIP::deleteInstance() {
      if (mpInstance) {
         delete mpInstance;
         mpInstance=0;
      }
   }







tDiaResult
dia_CommChannelDoIP::connect ( udd_UID /*uid*/ )
{

   dia_tclFnctTrace oTrace("dia_CommChannelDoIP::connect");

   tDiaResult retCode = DIA_SUCCESS;


   DIA_TR_INF(("--- dia_CommChannelDoIP::connect => Successfully spawn the thread."));

   dia_AppController* pAppCtrl = getInstanceOfAppController();
   if (pAppCtrl)
   {
      pAppCtrl->addRunlevelListener(this);
   }
   else
   {
      DIA_TR_INF( "!!! dia_CommChannelDoIP::connect => ERROR: Unable to register for RunLevel changes" );
      retCode = DIA_FAILED;
   }

   dia_EngineServer* pEngine = 0;
   if (( getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine) == DIA_SUCCESS ) && pEngine)
   {
      pEngine->getSessionController()->addListener(this);
   }
   else
   {
      DIA_TR_INF("!!! dia_CommChannelDoIP::connect => ERROR: Unable to register for Session changes");
      retCode = DIA_FAILED;
   }

   /*   dia_SecurityManager* pSecMgr = getInstanceOfSecurityManager();
        if ( pSecMgr )
        {
        pSecMgr->addListener(this);
        }
        else
        {
        DIA_TR_INF("!!! dia_CommChannelDoIP::connect => ERROR: Security manager is not available");
        }*/
   return retCode;
}

tDiaResult
dia_CommChannelDoIP::disconnect ( udd_UID /*uid*/ )
{
   dia_tclFnctTrace oTrace("dia_CommChannelDoIP::disconnect");
   tDiaResult retCode = DIA_SUCCESS;
   dia_LockScope mScopeLock(mSyncObj);
   {
      // disconnection should be done by DoIP stack
      _sender=0;
   }


#if 0 //STC2HI: TODO
   if ( hDevice != DIA_OSAL_ERROR )
   {
      // we have a connection so we disconnect now
      dia_Engine* pEngine = 0;
      if ( dia_EngineController::getInstance()->queryEngine(DIA_EN_ENGINE_ID_CUSTOMER,&pEngine) != DIA_SUCCESS )
      {
         DIA_TR_ERR("##### UNABLE TO RETRIEVE POINTER TO DIAGNOSIS ENGINE #####");
         return DIA_FAILED;
      }

      pEngine->getSessionController()->removeListener(this);

      if ( dia_OSAL_s32IOClose(hDevice) == DIA_OSAL_ERROR )
      {
         DIA_TR_INF( "dia_CommChannelDoIP::disconnect - OSAL returned an error when closing the UDS/CAN driver" );
         retCode = DIA_FAILED;
      }
      else
      {
         DIA_TR_INF( "dia_CommChannelDoIP::disconnect - Successfully closed UDS/CAN driver" );
      }

      hDevice = DIA_OSAL_ERROR;
   }
#endif //STC2HI: TODO

   /*   dia_SecurityManager* pSecMgr = getInstanceOfSecurityManager();
        if ( pSecMgr )
        {
        pSecMgr->removeListener(this);
        }
        else
        {
        DIA_TR_INF("!!! dia_CommChannelDoIP::disconnect => ERROR: Security manager is not available");
        } */

   return retCode;
}

tVoid dia_CommChannelDoIP::onDiagnosisResponse ( const tU8 au8MsgBuffer[], tU16 u16Length ) {
   dia_tclFnctTrace oTrace("dia_CommChannelDoIP::onDiagnosisResponse");
   if ( !au8MsgBuffer )
   {
      DIA_TR_INF( "!!! dia_CommChannelDoIP::onDiagnosisResponse => ERROR: au8MsgBuffer == NULL" );
      return;
   }

   for (IDiagnosisResponseListener * curListener : _onDiagnosisResponseListenerRep) {
      if (curListener) {
         DIA_TR_INF( "!!! dia_CommChannelDoIP::onDiagnosisResponse => call listener (%p)",  curListener);
         curListener->onDiagnosisResponse(au8MsgBuffer, u16Length);
      }
   }
   
   dia_LockScope mScopeLock(mSyncObj);
   {
      u8ActiveSID = 0;
      oP2Timer.s32SetTime(0,0);
      oP2Timer.removeTimerListener(this);

      if (!_sender) {
         DIA_TR_INF( "!!! dia_CommChannelDoIP::onDiagnosisResponse => ERROR: _sender == NULL" );
         return;
      }
      
      if (isConnected()) {
         _sender->onDiagnosisResponse(au8MsgBuffer, u16Length);
      }
   }
}

tVoid dia_CommChannelDoIP::vOnSessionChanged ( tU8 newSession, tU8 oldSession )
{
   dia_tclFnctTrace oTrace("dia_CommChannelDoIP::vOnSessionChanged");
     if (!_connected || !_sender) {
         return;
      }
      if ( newSession == oldSession ) {
         return;
      }

      DIA_TR_INF("dia_CommChannelDoIP::vOnSessionChanged newSession=0x%02x oldSession=0x%02x", newSession, oldSession);

}

   //! overloaded method from dia_IRunLevelListener
tVoid dia_CommChannelDoIP::vOnRunLevelChanged ( dia_enRunlevel newLevel, dia_enRunlevel oldLevel ) {
      dia_tclFnctTrace oTrace("dia_CommChannelDoIP::vOnRunLevelChanged");
      dia_AppController* pAppCtrl = getInstanceOfAppController();
      if ( !pAppCtrl ) return;
      
      tU32 appState = (tU32) pAppCtrl->getAppState();
      DIA_TR_INF("dia_CommChannelDoIP::vOnRunLevelChanged => newLevel = %d, oldLevel = %d, appState = %d",
                 newLevel, oldLevel, appState);
#if 0
      //todo: what have we got to do in case of DoIP?
      // below code of INC
      if ((oldLevel == DIA_EN_RUNLEVEL_UNDEFINED) && (newLevel== DIA_EN_RUNLEVEL_1))
      {
         // Cold start
         getInstanceOfSCCManager()->onSccStatusRequest(dia::DIA_EN_SCC_COMP_STATUS_ACTIVE);
      }
      
      else if ((oldLevel == DIA_EN_RUNLEVEL_2) && (newLevel== DIA_EN_RUNLEVEL_1))
      {
         if ( appState == DIA_C_U32_APP_STATE_OFF )
         {
            // Shutdown
            getInstanceOfSCCManager()->onSccStatusRequest(dia::DIA_EN_SCC_COMP_STATUS_INACTIVE);
         }
      }
      
      else if ((oldLevel == DIA_EN_RUNLEVEL_1) && (newLevel== DIA_EN_RUNLEVEL_2))
      {
         if ( appState == DIA_C_U32_APP_STATE_NORMAL )
         {
            //Warm start
            getInstanceOfSCCManager()->onSccStatusRequest(dia::DIA_EN_SCC_COMP_STATUS_ACTIVE);
         }
      }
#endif

   }

void dia_CommChannelDoIP::vOnSecurityLevelChanged ( dia_SecurityLevel* /*pNewLevel*/, dia_SecurityLevel* /*pOldLevel*/ )
{
   dia_tclFnctTrace oTrace("dia_CommChannelDoIP::vOnSecurityLevelChanged");
}


/* dia_IDoIPListener: reception has started */
tU32 dia_CommChannelDoIP::u32RxStartOfReception(tU32 u32Len) { 
   DIA_TR_INF("dia_CommChannelDoIP::u32RxStartOfReception():  u32Len=%u", u32Len);
   return u32Len; 
};


void dia_CommChannelDoIP::vRxIndication(tU8 au8Data[], tU32 u32Len) {

   // pause the S3 timer during an active service processing. will be continued after service is finished
   oS3Timer.s32SetTime(0,0);
   oS3Timer.removeTimerListener(this);

   if(au8Data[0] == cu8SID_TesterPresent)
   {
      // TesterPresent detected, remain in active session for another interval

      // check whether response is required
      bool bSuppressResp = ((au8Data[1] & cu8SUB_SupprPosRespUDS) == cu8SUB_SupprPosRespUDS);

      if(!bSuppressResp)
      {
         tU8 u8RespLen = 1;
         tU8 au8Response[6];

         au8Response[0] = cu8SID_TesterPresent+cu8SID_RespOffset;

         // UDS requires to mirror the 2nd byte
         au8Response[1] = au8Data[1];
         u8RespLen += 1;
         _sender->onDiagnosisResponse(au8Response, u8RespLen);
         // S3 timer will be reloaded in vTxConfirmation()
      }
   }
   else
   {
      u8ActiveSID = au8Data[0];

      // start P2 to keep the channel alive
      oP2Timer.addTimerListener(this);
      oP2Timer.s32SetTime(0,0);
      oP2Timer.s32SetTime(cu16P2, cu16P2ext);

      dia_MessageBufferUDS* pMsgBufferUDS = DIA_NEW dia_MessageBufferUDS (
                                                                          au8Data, (tU16)u32Len,
                                                                          dia_CommChannelDoIP::onDiagnosisResponse,
                                                                          dia_MessageBuffer::holds_request,
                                                                          dia_MessageBuffer::format_raw,
                                                                          tCookieType(this) // cookie
                                                                          );
      if ( pMsgBufferUDS && (handleMessage(*pMsgBufferUDS) == DIA_E_NOT_AVAILABLE) )
      {
         getInstanceOfApplication()->postMessage(DIA_NEW dia_tclDiagSession::tclEventReqRx(pMsgBufferUDS));
         DIA_TR_INF("--- dia_CommChannelDoIP::onDiagnosisRequest => Posted as UDS message");
      }

   }

}

void dia_CommChannelDoIP::vTxConfirmation(tBool bOk)
{
   if(u8ActiveSID == 0) // wait until a onDiagnosisResponse() was called to skip this callback on RespPending
   {
      // active service is done, reload the S3 timer to keep the current session alive
      oS3Timer.addTimerListener(this);
      oS3Timer.s32SetTime(0,0);
      oS3Timer.s32SetTime(cu16S3Server,0);

      if (bOk == true)
      {
         getInstanceOfApplication()->postMessage(DIA_NEW dia_tclDiagSession::tclEventConfTxOk());  // lint !e429: custodial pointer is freed by after engine has processed the message
      }
   }
}

void dia_CommChannelDoIP::vRxError(tU32 u32Error)
{
   if(u8ActiveSID == 0)
   {
      // a request failed, but assume it shall reload TesterPresent
      oS3Timer.addTimerListener(this);
      oS3Timer.s32SetTime(0,0);
      oS3Timer.s32SetTime(cu16S3Server,0);
   }
}




void dia_CommChannelDoIP::vResponsePendingTimeout(void)
{
   dia_LockScope mScopeLock(mSyncObj);

   if (!_sender) {
      DIA_TR_INF( "!!! dia_CommChannelDoIP::onDiagnosisResponse => ERROR: _sender == NULL" );
      return;
   }

   if (isConnected()) {

      const tU8 cu8RespSize = 3;
      tU8 au8Response[cu8RespSize+3]; // reserve some additional bytes for subsequent usage
      au8Response[0] = cu8SID_NegResp;
      au8Response[1] = u8ActiveSID;
      au8Response[2] = cu8NRC_ResponsePending;

      _sender->onDiagnosisResponse(au8Response, cu8RespSize);

      // RP timer will expire periodically with extended timeout until stopped
   }
}

void dia_CommChannelDoIP::vTesterTimeout(void)
{
   setDefaultSession();
}

void dia_CommChannelDoIP::vOnTimerElapsed ( dia_TimerID id )
{
   tU32 timerID = (tU32) id;

   if(timerID == mP2TimerID)
   {
      vResponsePendingTimeout();
   }
   else if(timerID == mS3TimerID)
   {
      vTesterTimeout();
   }
}




void dia_CommChannelDoIP::setDefaultSession() {
   tU8 defSession = 0;
   static tU8 tempBuffer[] = { 3, DIA_C_U8_UDS_SID_SESSION_CONTROL, 0x00 /* project specific default session ID will be available later */ };
   tU32 retCode = dia_getProperty(DIA_PROP_DEFAULT_SESSION, defSession);
   if (DIA_SUCCESS != retCode)
   {
      DIA_TR_INF("!!!  dia_CommChannelDoIP::setDefaultSession => ERROR: dia_getProperty FAILED retCode=0x%08X", retCode);
      return;

   }
   tempBuffer[2] = defSession;
   DIA_TR_INF("dia_CommChannelDoIP::setDefaultSession: default session ID is 0x%02X", defSession);

   dia_MessageBufferUDS* pMsgBuff = new dia_MessageBufferUDS (
                                                              &tempBuffer[0],
                                                              tU16(sizeof tempBuffer),
                                                              dia_tclDiagSessionUds::vNullResponse
                                                              );

#ifndef __DIA_UNIT_TESTING__
   if ( !pMsgBuff )
   {
      DIA_TR_INF("dia_CommChannelDoIP::setDefaultSession ERROR. NO MEMORY for dia_MessageBufferUDS object.");
      FATAL_M_ASSERT_ALWAYS();
   }
   // Create and send a ReqRx event to the uds session queue
   dia_Application::getInstance()->postMessage(new dia_tclDiagSession::tclEventReqRx(pMsgBuff));
#endif

}
void dia_CommChannelDoIP::onDoipChnDestroy ()
{
   dia_LockScope mScopeLock(mSyncObj);
   {
      dia_tclFnctTrace oTrace("dia_CommChannelDoIP::onDoipChnDestroy");
      setDefaultSession();
      _sender=0;
   }

}

void dia_CommChannelDoIP::OnDiagRequest (const unsigned char* in_pTxBuffer, tU16 dataLength) {
   dia_tclFnctTrace oTrace("dia_CommChannelDoIP::OnDiagRequest");
   dia_MessageBufferUDS* pMsgBuff = OSAL_NEW dia_MessageBufferUDS (
                                                                   in_pTxBuffer,
                                                                   dataLength,
                                                                   dia_CommChannelDoIP::onDiagnosisResponse,
                                                                   dia_MessageBuffer::holds_request,
                                                                      dia_MessageBuffer::format_raw,
                                                                   (tCookieType)_uid
                                                                   );
   dia_Application::getInstance()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventReqRx(pMsgBuff));
      DIA_TR_INF( "--- dia_CommChannelDoIP::OnDiagRequest => Posted as UDS message" );
};


/* static */
tVoid dia_CommChannelDoIP::onDiagnosisResponse ( const tU8 au8MsgBuffer[], tU16 u16Length, tCookieType /*cookie*/ ) {
   dia_CommChannelDoIP *instance=getInstance();
   if (instance) {
      instance->onDiagnosisResponse(au8MsgBuffer, u16Length);
   }
}


}

